/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.Iterator;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.routing.SplittingStrategy;

public class ExpressionSplittingStrategy
implements SplittingStrategy<CoreEvent, Iterator<TypedValue<?>>> {
    public static final String DEFAULT_SPLIT_EXPRESSION = "#[payload]";
    private final String expression;
    private final ExpressionManager expressionManager;

    public ExpressionSplittingStrategy(ExpressionManager expressionManager, String expression) {
        this.expressionManager = expressionManager;
        this.expression = expression;
    }

    public ExpressionSplittingStrategy(ExpressionManager expressionManager) {
        this(expressionManager, DEFAULT_SPLIT_EXPRESSION);
    }

    @Override
    public Iterator<TypedValue<?>> split(CoreEvent event) {
        Iterator<TypedValue<?>> result = this.expressionManager.split(this.expression, event, BindingContextUtils.NULL_BINDING_CONTEXT);
        return result != null ? result : Collections.emptyList().iterator();
    }

    public boolean hasDefaultExpression() {
        return DEFAULT_SPLIT_EXPRESSION.equals(this.expression);
    }

    public String getExpression() {
        return this.expression;
    }
}

