/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.math.Range;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class RangeValueRule
extends Rule {
    private Range range;

    public RangeValueRule(Range range) {
        this.range = range;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode || node instanceof FloatingNode) {
            return true;
        }
        if (node instanceof SimpleTypeNode) {
            try {
                Long.parseLong(((SimpleTypeNode)node).getLiteralValue());
                return true;
            }
            catch (NumberFormatException parseLongException) {
                try {
                    Double.parseDouble(((SimpleTypeNode)node).getLiteralValue());
                    return true;
                }
                catch (NumberFormatException parseDoubleException) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.validate(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        return ErrorNodeFactory.createInvalidRangeValue(node.toString(), this.range.getMinimumNumber(), this.range.getMaximumNumber());
    }

    private boolean validate(Node node) {
        if (node instanceof IntegerNode) {
            Long value = ((IntegerNode)node).getValue();
            return this.range.containsLong((Number)value);
        }
        if (node instanceof FloatingNode) {
            BigDecimal value = ((FloatingNode)node).getValue();
            return this.range.containsDouble(value.doubleValue());
        }
        if (node instanceof SimpleTypeNode) {
            try {
                long parseLong = Long.parseLong(((StringNode)node).getValue());
                return this.range.containsLong(parseLong);
            }
            catch (NumberFormatException parseLongException) {
                try {
                    double parseDouble = Double.parseDouble(((StringNode)node).getValue());
                    return this.range.containsDouble(parseDouble);
                }
                catch (NumberFormatException parseDoubleException) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Maximum value";
    }
}

