/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.mule.api.annotation.NoImplement;
import org.mule.maven.client.api.model.ImmutableMavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;

@NoImplement
public interface MavenConfiguration {
    public File getLocalMavenRepositoryLocation();

    public List<RemoteRepository> getMavenRemoteRepositories();

    public Optional<File> getUserSettingsLocation();

    public Optional<File> getGlobalSettingsLocation();

    public Optional<File> getSettingsSecurityLocation();

    public boolean getForcePolicyUpdateNever();

    public boolean getForcePolicyUpdateAlways();

    public boolean getIgnoreArtifactDescriptorRepositories();

    public boolean getOfflineMode();

    public Optional<List<String>> getActiveProfiles();

    public Optional<List<String>> getInactiveProfiles();

    public Optional<Properties> getUserProperties();

    public static MavenConfigurationBuilder newMavenConfigurationBuilder() {
        return new MavenConfigurationBuilder();
    }

    public static class MavenConfigurationBuilder {
        private File localMavenRepository;
        private LinkedList<RemoteRepository> remoteRepositories = new LinkedList();
        private File userSettingsFile;
        private File globalSettingsFile;
        private File settingsSecurityFile;
        private boolean forcePolicyUpdateNever = false;
        private boolean forcePolicyUpdateAlways = false;
        private boolean offlineMode = false;
        private boolean ignoreArtifactDescriptorRepositories = true;
        private List<String> activeProfiles;
        private List<String> inactiveProfiles;
        private Properties userProperties;

        public MavenConfigurationBuilder localMavenRepositoryLocation(File localMavenRepository) {
            Objects.requireNonNull(localMavenRepository, "localMavenRepository cannot be null");
            this.localMavenRepository = localMavenRepository;
            return this;
        }

        public MavenConfigurationBuilder remoteRepository(RemoteRepository remoteRepository) {
            Objects.requireNonNull(remoteRepository, "remoteRepository cannot be null");
            this.remoteRepositories.addLast(remoteRepository);
            return this;
        }

        public MavenConfigurationBuilder userSettingsLocation(File userSettingsFile) {
            Objects.requireNonNull(userSettingsFile, "userSettingsFile cannot be null");
            this.userSettingsFile = userSettingsFile;
            return this;
        }

        public MavenConfigurationBuilder globalSettingsLocation(File globalSettingsFile) {
            Objects.requireNonNull(globalSettingsFile, "globalSettingsFile cannot be null");
            this.globalSettingsFile = globalSettingsFile;
            return this;
        }

        public MavenConfigurationBuilder settingsSecurityLocation(File settingsSecurityFile) {
            Objects.requireNonNull(settingsSecurityFile, "settingsSecurityFile cannot be null");
            this.settingsSecurityFile = settingsSecurityFile;
            return this;
        }

        public MavenConfigurationBuilder forcePolicyUpdateNever(boolean forcePolicyUpdateNever) {
            Objects.requireNonNull(Boolean.valueOf(forcePolicyUpdateNever), "forcePolicyUpdateNever cannot be null");
            this.forcePolicyUpdateNever = forcePolicyUpdateNever;
            return this;
        }

        public MavenConfigurationBuilder forcePolicyUpdateAlways(boolean forcePolicyUpdateAlways) {
            Objects.requireNonNull(Boolean.valueOf(forcePolicyUpdateAlways), "forcePolicyUpdateAlways cannot be null");
            this.forcePolicyUpdateAlways = forcePolicyUpdateAlways;
            return this;
        }

        public MavenConfigurationBuilder offlineMode(boolean offlineMode) {
            Objects.requireNonNull(Boolean.valueOf(offlineMode), "offlineMode cannot be null");
            this.offlineMode = offlineMode;
            return this;
        }

        public MavenConfigurationBuilder ignoreArtifactDescriptorRepositories(boolean ignoreArtifactDescriptorRepositories) {
            Objects.requireNonNull(Boolean.valueOf(ignoreArtifactDescriptorRepositories), "ignoreArtifactDescriptorRepositories cannot be null");
            this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
            return this;
        }

        public MavenConfigurationBuilder userProperties(Properties userProperties) {
            Objects.requireNonNull(userProperties, "userProperties cannot be null");
            this.userProperties = userProperties;
            return this;
        }

        public MavenConfigurationBuilder activeProfiles(List<String> activeProfiles) {
            Objects.requireNonNull(activeProfiles, "activeProfiles cannot be null");
            this.activeProfiles = activeProfiles;
            return this;
        }

        public MavenConfigurationBuilder inactiveProfiles(List<String> inactiveProfiles) {
            Objects.requireNonNull(inactiveProfiles, "inactiveProfiles cannot be null");
            this.inactiveProfiles = inactiveProfiles;
            return this;
        }

        public MavenConfiguration build() {
            return new ImmutableMavenConfiguration(this.localMavenRepository, this.remoteRepositories, Optional.ofNullable(this.userSettingsFile), Optional.ofNullable(this.globalSettingsFile), this.forcePolicyUpdateNever, this.forcePolicyUpdateAlways, this.offlineMode, this.ignoreArtifactDescriptorRepositories, this.settingsSecurityFile, this.activeProfiles, this.inactiveProfiles, this.userProperties);
        }
    }
}

