/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.List;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceResolver;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;
import org.mule.runtime.module.service.internal.manager.ServiceRegistry;

public class DefaultServiceDiscoverer
implements ServiceDiscoverer {
    private final ServiceResolver serviceResolver;
    private final ServiceProviderDiscoverer serviceProviderDiscoverer;

    public DefaultServiceDiscoverer(ServiceProviderDiscoverer serviceProviderDiscoverer) {
        this(serviceProviderDiscoverer, new ReflectionServiceResolver(new ServiceRegistry()));
    }

    public DefaultServiceDiscoverer(ServiceProviderDiscoverer serviceProviderDiscoverer, ServiceResolver serviceResolver) {
        Preconditions.checkArgument((serviceProviderDiscoverer != null ? 1 : 0) != 0, (String)"serviceProviderDiscoverer cannot be null");
        Preconditions.checkArgument((serviceResolver != null ? 1 : 0) != 0, (String)"serviceDependencyResolver cannot be null");
        this.serviceResolver = serviceResolver;
        this.serviceProviderDiscoverer = serviceProviderDiscoverer;
    }

    @Override
    public List<Service> discoverServices() throws ServiceResolutionError {
        try {
            List<ServiceAssembly> assemblies = this.serviceProviderDiscoverer.discover();
            return this.serviceResolver.resolveServices(assemblies);
        }
        catch (ServiceResolutionError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceResolutionError(e.getMessage(), e);
        }
    }
}

