/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.metadata.TypedValue;

public class DefaultBindingContextBuilder
implements BindingContext.Builder {
    private TypedValue payloadBinding;
    private TypedValue attributesBinding;
    private Optional<Supplier<TypedValue>> varsBinding = Optional.empty();
    private boolean bindingAdded = false;
    private LinkedList<BindingContext> delegates = new LinkedList();
    private Map<String, Supplier<TypedValue>> bindings = new HashMap<String, Supplier<TypedValue>>();
    private Collection<ExpressionModule> modules = null;

    public DefaultBindingContextBuilder() {
    }

    public DefaultBindingContextBuilder(BindingContext bindingContext) {
        this.delegates.add(bindingContext);
        this.payloadBinding = bindingContext.lookup("payload").orElse(null);
        this.attributesBinding = bindingContext.lookup("attributes").orElse(null);
        this.varsBinding = bindingContext.lookup("vars").flatMap(vars -> Optional.of(() -> vars));
    }

    public BindingContext.Builder addBinding(String identifier, TypedValue value) {
        this.bindingAdded = true;
        switch (identifier) {
            case "payload": {
                this.payloadBinding = value;
                break;
            }
            case "attributes": {
                this.attributesBinding = value;
                break;
            }
            case "vars": {
                this.varsBinding = Optional.of(() -> value);
                break;
            }
            default: {
                this.bindings.put(identifier, () -> value);
            }
        }
        return this;
    }

    public BindingContext.Builder addBinding(String identifier, Supplier<TypedValue> lazyValue) {
        this.bindingAdded = true;
        switch (identifier) {
            case "payload": {
                this.payloadBinding = lazyValue.get();
                break;
            }
            case "attributes": {
                this.attributesBinding = lazyValue.get();
                break;
            }
            case "vars": {
                this.varsBinding = Optional.of(lazyValue);
                break;
            }
            default: {
                this.bindings.put(identifier, lazyValue);
            }
        }
        return this;
    }

    public BindingContext.Builder addAll(BindingContext context) {
        if (this.bindingAdded) {
            this.delegates.addFirst(new BindingContextImplementation(Collections.emptyList(), Collections.unmodifiableMap(this.bindings), this.payloadBinding, this.attributesBinding, this.varsBinding, this.modules != null ? Collections.unmodifiableCollection(this.modules) : Collections.emptyList()));
            this.payloadBinding = null;
            this.attributesBinding = null;
            this.varsBinding = Optional.empty();
            this.bindings = new HashMap<String, Supplier<TypedValue>>();
            this.modules = null;
            this.bindingAdded = false;
        }
        this.payloadBinding = context.lookup("payload").orElse(this.payloadBinding);
        this.attributesBinding = context.lookup("attributes").orElse(this.attributesBinding);
        context.lookup("vars").ifPresent(vars -> {
            this.varsBinding = Optional.of(() -> vars);
        });
        this.delegates.addFirst(context);
        return this;
    }

    public BindingContext.Builder addModule(ExpressionModule expressionModule) {
        this.bindingAdded = true;
        if (this.modules == null) {
            this.modules = new ArrayList<ExpressionModule>();
        }
        this.modules.add(expressionModule);
        return this;
    }

    public BindingContext build() {
        return new BindingContextImplementation(new ArrayList<BindingContext>(this.delegates), Collections.unmodifiableMap(this.bindings), this.payloadBinding, this.attributesBinding, this.varsBinding, this.modules != null ? Collections.unmodifiableCollection(this.modules) : Collections.emptyList());
    }

    public BindingContext flattenAndBuild() {
        BindingContext original = this.build();
        HashMap<String, Supplier<TypedValue>> flattenedBindings = new HashMap<String, Supplier<TypedValue>>();
        for (Binding binding : original.bindings()) {
            if (flattenedBindings.containsKey(binding.identifier()) || "payload".equals(binding.identifier()) || "attributes".equals(binding.identifier()) || "vars".equals(binding.identifier())) continue;
            flattenedBindings.put(binding.identifier(), () -> binding.value());
        }
        return new BindingContextImplementation(Collections.emptyList(), flattenedBindings, original.lookup("payload").orElse(null), original.lookup("attributes").orElse(null), Optional.of(() -> original.lookup("vars").orElse(null)), original.modules());
    }

    public static class BindingContextImplementation
    implements BindingContext {
        private final List<BindingContext> delegates;
        private final Optional<TypedValue> payloadBinding;
        private final Optional<TypedValue> attributesBinding;
        private final Supplier<TypedValue> varsBinding;
        private final Map<String, Supplier<TypedValue>> bindings;
        private final Collection<ExpressionModule> modules;

        private BindingContextImplementation(List<BindingContext> delegates, Map<String, Supplier<TypedValue>> bindings, TypedValue payloadBinding, TypedValue attributesBinding, Optional<Supplier<TypedValue>> varsBinding, Collection<ExpressionModule> modules) {
            this.delegates = delegates;
            this.bindings = bindings;
            this.payloadBinding = Optional.ofNullable(payloadBinding);
            this.attributesBinding = Optional.ofNullable(attributesBinding);
            this.varsBinding = varsBinding.orElse(() -> null);
            this.modules = modules;
        }

        private Optional<TypedValue> lookUpInDelegates(String identifier) {
            for (BindingContext bindingContext : this.delegates) {
                Optional result = bindingContext.lookup(identifier);
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.empty();
        }

        public Collection<Binding> bindings() {
            HashMap<String, Binding> bindingsMap = new HashMap<String, Binding>();
            for (Map.Entry<String, Supplier<TypedValue>> entry : this.bindings.entrySet()) {
                bindingsMap.put(entry.getKey(), new Binding(entry.getKey(), entry.getValue() != null ? entry.getValue().get() : null));
            }
            this.payloadBinding.ifPresent(pb -> bindingsMap.put("payload", new Binding("payload", this.payloadBinding.get())));
            this.attributesBinding.ifPresent(pb -> bindingsMap.put("attributes", new Binding("attributes", this.attributesBinding.get())));
            if (this.varsBinding.get() != null) {
                bindingsMap.put("vars", new Binding("vars", this.varsBinding.get()));
            }
            for (BindingContext bindingContext : this.delegates) {
                for (Binding binding : bindingContext.bindings()) {
                    bindingsMap.putIfAbsent(binding.identifier(), binding);
                }
            }
            return bindingsMap.values();
        }

        public Collection<String> identifiers() {
            HashSet<String> identifiers = new HashSet<String>(this.bindings.keySet());
            this.payloadBinding.ifPresent(pb -> identifiers.add("payload"));
            this.attributesBinding.ifPresent(pb -> identifiers.add("attributes"));
            if (this.varsBinding.get() != null) {
                identifiers.add("vars");
            }
            for (BindingContext bindingContext : this.delegates) {
                identifiers.addAll(bindingContext.identifiers());
            }
            return identifiers;
        }

        public Optional<TypedValue> lookup(String identifier) {
            switch (identifier) {
                case "payload": {
                    return this.payloadBinding;
                }
                case "attributes": {
                    return this.attributesBinding;
                }
                case "vars": {
                    return Optional.ofNullable(this.varsBinding.get());
                }
            }
            Supplier<TypedValue> supplier = this.bindings.get(identifier);
            return supplier != null ? Optional.ofNullable(supplier.get()) : this.lookUpInDelegates(identifier);
        }

        public Collection<ExpressionModule> modules() {
            ArrayList<ExpressionModule> mods = new ArrayList<ExpressionModule>();
            mods.addAll(this.modules);
            for (BindingContext bindingContext : this.delegates) {
                mods.addAll(bindingContext.modules());
            }
            return mods;
        }
    }
}

