/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.core.api.policy.PolicyInstance;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleManager;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;
import org.mule.runtime.core.internal.policy.PolicyNextActionMessageProcessor;
import org.mule.runtime.core.internal.processor.chain.InterceptedReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.StreamPerEventSink;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.retry.BackoffDelay;
import reactor.retry.Retry;

@NoExtend
public class DefaultPolicyInstance
extends AbstractComponent
implements PolicyInstance,
FlowConstruct,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyInstance.class);
    @Inject
    private SchedulerService schedulerService;
    private ProcessingStrategy processingStrategy;
    private String name;
    private PolicyChain operationPolicyChain;
    private PolicyChain sourcePolicyChain;
    private FlowConstructStatistics flowConstructStatistics;
    private MuleContext muleContext;
    private final DefaultLifecycleManager<DefaultPolicyInstance> lifecycleStateManager = new DefaultLifecycleManager<DefaultPolicyInstance>("proxy-policy-" + UUID.getUUID(), this);

    public void initialise() throws InitialisationException {
        this.flowConstructStatistics = new DefaultFlowConstructStatistics("policy", this.getName());
        this.processingStrategy = new PolicyProcessingStrategy(this.schedulerService, this.muleContext.getSchedulerBaseConfig(), this.getName());
        if (this.operationPolicyChain != null) {
            this.operationPolicyChain.setProcessingStrategy(this.processingStrategy);
        }
        if (this.sourcePolicyChain != null) {
            this.sourcePolicyChain.setProcessingStrategy(this.processingStrategy);
        }
        LifecycleUtils.initialiseIfNeeded(this.operationPolicyChain, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.sourcePolicyChain, this.muleContext);
        this.lifecycleStateManager.fireInitialisePhase((phaseNam, object) -> {});
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processingStrategy);
        LifecycleUtils.startIfNeeded(this.operationPolicyChain);
        LifecycleUtils.startIfNeeded(this.sourcePolicyChain);
        this.lifecycleStateManager.fireStartPhase((phaseNam, object) -> {});
    }

    @Override
    public FlowExceptionHandler getExceptionListener() {
        return new FlowExceptionHandler(){

            @Override
            public CoreEvent handleException(Exception exception, CoreEvent event) {
                return null;
            }

            @Override
            public Publisher<CoreEvent> apply(Exception exception) {
                return Mono.error((Throwable)exception);
            }
        };
    }

    @Override
    public FlowConstructStatistics getStatistics() {
        return this.flowConstructStatistics;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public String getUniqueIdString() {
        return this.muleContext.getUniqueIdString();
    }

    @Override
    public String getServerId() {
        return this.muleContext.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleStateManager.getState();
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.operationPolicyChain, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.sourcePolicyChain, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.processingStrategy, LOGGER);
        this.lifecycleStateManager.fireDisposePhase((phaseNam, object) -> {});
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.operationPolicyChain);
        LifecycleUtils.stopIfNeeded(this.sourcePolicyChain);
        LifecycleUtils.stopIfNeeded(this.processingStrategy);
        this.lifecycleStateManager.fireStopPhase((phaseNam, object) -> {});
    }

    public void setOperationPolicyChain(PolicyChain request) {
        this.operationPolicyChain = request;
    }

    public void setSourcePolicyChain(PolicyChain source) {
        this.sourcePolicyChain = source;
    }

    @Override
    public Optional<PolicyChain> getSourcePolicyChain() {
        return Optional.ofNullable(this.sourcePolicyChain);
    }

    @Override
    public Optional<PolicyChain> getOperationPolicyChain() {
        return Optional.ofNullable(this.operationPolicyChain);
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    private static final class PolicyProcessingStrategy
    extends AbstractProcessingStrategy
    implements ProcessingStrategy,
    Startable,
    Disposable {
        private static final Logger LOGGER = LoggerFactory.getLogger(PolicyProcessingStrategy.class);
        private final SchedulerService schedulerService;
        private final SchedulerConfig schedulerBaseConfig;
        private final String schedulersNamePrefix;
        private Scheduler ioScheduler;
        private Scheduler cpuIntensiveScheduler;
        private Scheduler cpuLiteScheduler;

        public PolicyProcessingStrategy(SchedulerService schedulerService, SchedulerConfig schedulerBaseConfig, String schedulersNamePrefix) {
            this.schedulerService = schedulerService;
            this.schedulerBaseConfig = schedulerBaseConfig;
            this.schedulersNamePrefix = schedulersNamePrefix;
        }

        public void start() throws MuleException {
            this.ioScheduler = this.schedulerService.ioScheduler(this.schedulerBaseConfig.withName(this.schedulersNamePrefix));
            this.cpuIntensiveScheduler = this.schedulerService.cpuIntensiveScheduler(this.schedulerBaseConfig.withName(this.schedulersNamePrefix));
            this.cpuLiteScheduler = this.schedulerService.cpuLightScheduler(this.schedulerBaseConfig.withName(this.schedulersNamePrefix + "-cpuLite"));
        }

        public void stopSchedulers() {
            if (this.cpuLiteScheduler != null) {
                this.cpuLiteScheduler.stop();
            }
            if (this.cpuIntensiveScheduler != null) {
                this.cpuIntensiveScheduler.stop();
            }
            if (this.ioScheduler != null) {
                this.ioScheduler.stop();
            }
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return new StreamPerEventSink(pipeline, this.createOnEventConsumer());
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)super.onPipeline(pipeline));
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (this.isExecuteNext(processor)) {
                return super.onProcessor(processor);
            }
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return this.switchBackThreadPool(processor);
            }
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.IO_RW || processor.getProcessingType() == ReactiveProcessor.ProcessingType.BLOCKING) {
                return this.switchThreadPool(processor, this.ioScheduler);
            }
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_INTENSIVE) {
                return this.switchThreadPool(processor, this.cpuIntensiveScheduler);
            }
            return super.onProcessor(processor);
        }

        private boolean isExecuteNext(ReactiveProcessor processor) {
            return processor instanceof PolicyNextActionMessageProcessor || processor instanceof InterceptedReactiveProcessor && ((InterceptedReactiveProcessor)processor).getProcessor() instanceof PolicyNextActionMessageProcessor;
        }

        private ReactiveProcessor switchBackThreadPool(ReactiveProcessor processor) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).publishOn(Schedulers.fromExecutorService((ExecutorService)this.cpuLiteScheduler)).retryWhen((Function)Retry.onlyIf(ctx -> {
                boolean schedulerBusy = this.isSchedulerBusy(ctx.exception());
                if (schedulerBusy) {
                    LOGGER.trace("Shared scheduler {} is busy. Scheduling of the current event will be retried after {}ms.", (Object)this.cpuLiteScheduler.getName(), (Object)2L);
                }
                return schedulerBusy;
            }).backoff(ctx -> new BackoffDelay(Duration.ofMillis(2L))).withBackoffScheduler(Schedulers.fromExecutorService((ExecutorService)this.cpuLiteScheduler)));
        }

        private ReactiveProcessor switchThreadPool(ReactiveProcessor processor, Scheduler targetScheduler) {
            return publisher -> Flux.from((Publisher)publisher).publishOn(Schedulers.fromExecutor((Executor)targetScheduler)).transform((Function)processor).retryWhen((Function)Retry.onlyIf(ctx -> {
                boolean schedulerBusy = this.isSchedulerBusy(ctx.exception());
                if (schedulerBusy) {
                    LOGGER.trace("Shared scheduler {} is busy. Scheduling of the current event will be retried after {}ms.", (Object)targetScheduler.getName(), (Object)2L);
                }
                return schedulerBusy;
            }).backoff(ctx -> new BackoffDelay(Duration.ofMillis(2L))).withBackoffScheduler(Schedulers.fromExecutorService((ExecutorService)this.cpuLiteScheduler)));
        }

        public void dispose() {
            this.stopSchedulers();
        }
    }
}

