/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProactorStreamWorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ReactorStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.TransactionAwareProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.TransactionalDelegateSink;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;

public class TransactionAwareProactorStreamWorkQueueProcessingStrategyFactory
extends ReactorStreamProcessingStrategyFactory
implements TransactionAwareProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new TransactionAwareProactorStreamWorkQueueProcessingStrategy(this.getRingBufferSchedulerSupplier(muleContext, schedulersNamePrefix), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name())), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), this.getMaxConcurrency(), this.isMaxConcurrencyEagerCheck(), muleContext.getConfiguration().isThreadLoggingEnabled());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return TransactionAwareProactorStreamWorkQueueProcessingStrategy.class;
    }

    static class TransactionAwareProactorStreamWorkQueueProcessingStrategy
    extends ProactorStreamWorkQueueProcessingStrategyFactory.ProactorStreamWorkQueueProcessingStrategy {
        TransactionAwareProactorStreamWorkQueueProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscriberCount, String waitStrategy, Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, int maxConcurrency, boolean maxConcurrencyEagerCheck, boolean isThreadLoggingEnabled) {
            super(ringBufferSchedulerSupplier, bufferSize, subscriberCount, waitStrategy, cpuLightSchedulerSupplier, blockingSchedulerSupplier, cpuIntensiveSchedulerSupplier, AbstractStreamProcessingStrategyFactory.CORES, maxConcurrency, maxConcurrencyEagerCheck, isThreadLoggingEnabled);
        }

        TransactionAwareProactorStreamWorkQueueProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscriberCount, String waitStrategy, Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
            this(ringBufferSchedulerSupplier, bufferSize, subscriberCount, waitStrategy, cpuLightSchedulerSupplier, blockingSchedulerSupplier, cpuIntensiveSchedulerSupplier, maxConcurrency, maxConcurrencyEagerCheck, false);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            Sink proactorSink = super.createSink(flowConstruct, pipeline);
            Sink syncSink = BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.createSink(flowConstruct, pipeline);
            return new TransactionalDelegateSink(syncSink, proactorSink);
        }

        @Override
        protected Consumer<CoreEvent> createOnEventConsumer() {
            return event -> {};
        }

        @Override
        protected ExecutorService decorateScheduler(Scheduler scheduler) {
            return new ConditionalExecutorServiceDecorator(scheduler, currentScheduler -> TransactionCoordination.isTransactionActive());
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            return TransactionCoordination.isTransactionActive() ? BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onPipeline(pipeline) : super.onPipeline(pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            return TransactionCoordination.isTransactionActive() ? BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onProcessor(processor) : super.onProcessor(processor);
        }
    }
}

