/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import javax.xml.namespace.QName;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;

public class PollingSourceDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        final ClassTypeLoader loader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
        final Reference thereArePollingSources = new Reference((Object)false);
        new IdempotentDeclarationWalker(){

            protected void onSource(SourceDeclaration source) {
                PollingSourceDeclarationEnricher.this.extractType((BaseDeclaration<? extends BaseDeclaration>)source).ifPresent(type -> {
                    if (type.isAssignableTo(PollingSource.class)) {
                        source.setRunsOnPrimaryNodeOnly(true);
                        ParameterDeclaration parameter = new ParameterDeclaration("schedulingStrategy");
                        parameter.setDescription("Configures the scheduler that triggers the polling");
                        parameter.setRequired(true);
                        parameter.setType(loader.load(Scheduler.class), false);
                        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                        parameter.addModelProperty((ModelProperty)new InfrastructureParameterModelProperty(10));
                        parameter.addModelProperty((ModelProperty)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "scheduling-strategy", "mule")));
                        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
                        thereArePollingSources.set((Object)true);
                        source.getParameterGroup("General").addParameter(parameter);
                    }
                });
            }
        }.walk((ExtensionDeclaration)extensionDeclarer.getDeclaration());
        if (((Boolean)thereArePollingSources.get()).booleanValue() && !this.isSchedulerAlreadyImported((ExtensionDeclaration)extensionDeclarer.getDeclaration())) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            extensionDeclarer.withImportedType(new ImportedTypeModel((ObjectType)typeLoader.load(Scheduler.class)));
        }
    }

    private boolean isSchedulerAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().anyMatch(model -> this.isScheduler((MetadataType)model.getImportedType()));
    }

    private boolean isScheduler(MetadataType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).filter(typeId -> Scheduler.class.getName().equals(typeId)).isPresent();
    }

    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }
}

