/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.connectivity.oauth;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.security.CredentialsPlacement;

public final class ClientCredentialsGrantType
implements OAuthGrantType {
    public static final String NAME = "Client Credentials";
    private final String tokenUrl;
    private final String accessTokenExpr;
    private final String expirationRegex;
    private final String defaultScopes;
    private final CredentialsPlacement credentialsPlacement;

    public ClientCredentialsGrantType(String tokenUrl, String accessTokenExpr, String expirationRegex, String defaultScopes, CredentialsPlacement credentialsPlacement) {
        this.notBlank(tokenUrl, "tokenUrl");
        this.notBlank(accessTokenExpr, "accessTokenExpr");
        this.notBlank(expirationRegex, "expirationRegex");
        this.notBlank(expirationRegex, "expirationRegex");
        this.tokenUrl = tokenUrl;
        this.accessTokenExpr = accessTokenExpr;
        this.expirationRegex = expirationRegex;
        this.defaultScopes = StringUtils.isBlank((CharSequence)defaultScopes) ? null : defaultScopes;
        this.credentialsPlacement = credentialsPlacement != null ? credentialsPlacement : CredentialsPlacement.BASIC_AUTH_HEADER;
    }

    @Override
    public void accept(OAuthGrantTypeVisitor visitor) {
        visitor.visit(this);
    }

    private void notBlank(String value, String name) {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException(name + " cannot be blank");
        }
    }

    public String getName() {
        return NAME;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getAccessTokenExpr() {
        return this.accessTokenExpr;
    }

    public String getExpirationRegex() {
        return this.expirationRegex;
    }

    public Optional<String> getDefaultScopes() {
        return Optional.ofNullable(this.defaultScopes);
    }

    public CredentialsPlacement getCredentialsPlacement() {
        return this.credentialsPlacement;
    }
}

