/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;

public class DefaultFlowCallStack
implements FlowCallStack {
    private static final long serialVersionUID = -8683711977929802819L;
    private final Deque<FlowStackElement> innerStack;

    public DefaultFlowCallStack() {
        this.innerStack = new ArrayDeque<FlowStackElement>(4);
    }

    private DefaultFlowCallStack(Deque<FlowStackElement> innerStack) {
        this.innerStack = new ArrayDeque<FlowStackElement>(innerStack);
    }

    public void push(FlowStackElement flowStackElement) {
        this.innerStack.push(flowStackElement);
    }

    public void setCurrentProcessorPath(String processorPath) {
        if (!this.innerStack.isEmpty()) {
            this.innerStack.push(new FlowStackElement(this.innerStack.pop().getFlowName(), processorPath));
        }
    }

    public FlowStackElement pop() {
        return this.innerStack.pop();
    }

    @Override
    public List<FlowStackElement> getElements() {
        return new ArrayList<FlowStackElement>(this.innerStack);
    }

    @Override
    public DefaultFlowCallStack clone() {
        return new DefaultFlowCallStack(this.innerStack);
    }

    public String toString() {
        StringBuilder stackString = new StringBuilder();
        int i = 0;
        for (FlowStackElement flowStackElement : this.innerStack) {
            stackString.append("at ").append(flowStackElement.toString());
            if (++i == this.innerStack.size()) continue;
            stackString.append(System.lineSeparator());
        }
        return stackString.toString();
    }
}

