/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.thread.notification;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.math3.stat.StatUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.context.thread.notification.ThreadNotificationService;

public class ThreadsStatistics {
    private MultiMap<Pair<String, String>, Double> times = new MultiMap();

    public synchronized void addThreadNotificationElement(ThreadNotificationService.ThreadNotificationElement notification) {
        Pair key = new Pair((Object)notification.getFromThreadType(), (Object)notification.getToThreadType());
        this.times.put((Object)key, (Object)new Double(notification.getLatencyTime()));
    }

    public synchronized void addThreadNotificationElements(Collection<ThreadNotificationService.ThreadNotificationElement> notifications) {
        notifications.stream().forEach(notification -> this.addThreadNotificationElement((ThreadNotificationService.ThreadNotificationElement)notification));
    }

    public Set<Pair<String, String>> getPossibleTransitions() {
        return this.times.keySet();
    }

    private double[] getTimes(String from, String to) {
        return this.times.getAll((Object)new Pair((Object)from, (Object)to)).stream().mapToDouble(i -> i).toArray();
    }

    public double getMean(String from, String to) {
        return StatUtils.mean((double[])this.getTimes(from, to));
    }

    public double getStdDeviation(String from, String to) {
        return Math.sqrt(StatUtils.variance((double[])this.getTimes(from, to)));
    }

    public double percentile(String from, String to, double quantile) {
        return StatUtils.percentile((double[])this.getTimes(from, to), (double)quantile);
    }

    public int getCount(String from, String to) {
        return this.getTimes(from, to).length;
    }

    public int getCount(Pair<String, String> transition) {
        return this.times.getAll(transition).size();
    }

    public double getMean(Pair<String, String> transition) {
        return this.getMean((String)transition.getFirst(), (String)transition.getSecond());
    }

    public double getStdDeviation(Pair<String, String> transition) {
        return this.getStdDeviation((String)transition.getFirst(), (String)transition.getSecond());
    }

    public double percentile(Pair<String, String> transition, double quantile) {
        return this.percentile((String)transition.getFirst(), (String)transition.getSecond(), quantile);
    }

    public void clear() {
        this.times.clear();
    }
}

