/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.concurrent.FunctionalReadWriteLock;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.AbstractCompositePolicy;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.RoundRobinFluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.TransactionAwareFluxSinkSupplier;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class CompositeOperationPolicy
extends AbstractCompositePolicy<OperationPolicyParametersTransformer>
implements OperationPolicy,
Disposable {
    public static final String POLICY_OPERATION_NEXT_OPERATION_RESPONSE = "policy.operation.nextOperationResponse";
    public static final String POLICY_OPERATION_PARAMETERS_PROCESSOR = "policy.operation.parametersProcessor";
    public static final String POLICY_OPERATION_OPERATION_EXEC_FUNCTION = "policy.operation.operationExecutionFunction";
    private static final String POLICY_OPERATION_CHILD_CTX = "policy.operation.childContext";
    private static final String POLICY_OPERATION_CALLER_SINK = "policy.operation.callerSink";
    private final OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private final LoadingCache<String, FluxSinkSupplier<CoreEvent>> policySinks;
    private final AtomicBoolean disposed;
    private final FunctionalReadWriteLock readWriteLock;

    public CompositeOperationPolicy(List<Policy> parameterizedPolicies, Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer, OperationPolicyProcessorFactory operationPolicyProcessorFactory) {
        super(parameterizedPolicies, operationPolicyParametersTransformer);
        this.operationPolicyProcessorFactory = operationPolicyProcessorFactory;
        this.disposed = new AtomicBoolean(false);
        this.readWriteLock = FunctionalReadWriteLock.readWriteLock();
        this.policySinks = Caffeine.newBuilder().removalListener((key, value, cause) -> value.dispose()).build(componentLocation -> {
            OperationWithPoliciesFluxObjectFactory factory = new OperationWithPoliciesFluxObjectFactory();
            return new TransactionAwareFluxSinkSupplier<CoreEvent>(factory, new RoundRobinFluxSinkSupplier<CoreEvent>(Runtime.getRuntime().availableProcessors(), factory));
        });
    }

    @Override
    protected Publisher<CoreEvent> applyNextOperation(Publisher<CoreEvent> eventPub, Policy lastPolicy) {
        return Flux.from(eventPub).flatMap(event -> {
            OperationParametersProcessor parametersProcessor = (OperationParametersProcessor)((InternalEvent)event).getInternalParameter(POLICY_OPERATION_PARAMETERS_PROCESSOR);
            HashMap<String, Object> parametersMap = new HashMap<String, Object>(parametersProcessor.getOperationParameters());
            if (this.getParametersTransformer().isPresent()) {
                parametersMap.putAll(((OperationPolicyParametersTransformer)this.getParametersTransformer().get()).fromMessageToParameters(event.getMessage()));
            }
            OperationExecutionFunction operationExecutionFunction = (OperationExecutionFunction)((InternalEvent)event).getInternalParameter(POLICY_OPERATION_OPERATION_EXEC_FUNCTION);
            return operationExecutionFunction.execute((Map<String, Object>)parametersMap, (CoreEvent)event);
        }).map(response -> EventQuickCopy.quickCopy(response, Collections.singletonMap(POLICY_OPERATION_NEXT_OPERATION_RESPONSE, response)));
    }

    @Override
    protected Publisher<CoreEvent> applyPolicy(Policy policy, ReactiveProcessor nextProcessor, Publisher<CoreEvent> eventPub) {
        ReactiveProcessor defaultOperationPolicy = this.operationPolicyProcessorFactory.createOperationPolicy(policy, nextProcessor);
        return Flux.from(eventPub).transform((Function)defaultOperationPolicy);
    }

    @Override
    public Publisher<CoreEvent> process(CoreEvent operationEvent, OperationExecutionFunction operationExecutionFunction, OperationParametersProcessor parametersProcessor, ComponentLocation operationLocation) {
        return (Publisher)this.readWriteLock.withReadLock(lockReleaser -> {
            if (!this.disposed.get()) {
                return Mono.create(callerSink -> {
                    FluxSink policySink = (FluxSink)((FluxSinkSupplier)this.policySinks.get((Object)operationLocation.getLocation())).get();
                    policySink.next((Object)this.operationEventForPolicy(EventQuickCopy.quickCopy((EventContext)MessageProcessors.newChildContext(operationEvent, Optional.of(operationLocation)), operationEvent), operationExecutionFunction, parametersProcessor, (MonoSink<CoreEvent>)callerSink));
                });
            }
            MessagingException me = new MessagingException(I18nMessageFactory.createStaticMessage((String)"Operation policy already disposed"), operationEvent);
            return Mono.error((Throwable)((Object)me));
        });
    }

    private CoreEvent operationEventForPolicy(CoreEvent operationEvent, OperationExecutionFunction operationExecutionFunction, OperationParametersProcessor parametersProcessor, MonoSink<CoreEvent> callerSink) {
        return this.getParametersTransformer().isPresent() ? InternalEvent.builder(operationEvent).message(((OperationPolicyParametersTransformer)this.getParametersTransformer().get()).fromParametersToMessage(parametersProcessor.getOperationParameters())).addInternalParameter(POLICY_OPERATION_PARAMETERS_PROCESSOR, parametersProcessor).addInternalParameter(POLICY_OPERATION_OPERATION_EXEC_FUNCTION, operationExecutionFunction).addInternalParameter(POLICY_OPERATION_CHILD_CTX, operationEvent.getContext()).addInternalParameter(POLICY_OPERATION_CALLER_SINK, callerSink).build() : EventQuickCopy.quickCopy(operationEvent, (Map<String, Object>)ImmutableMap.of((Object)POLICY_OPERATION_PARAMETERS_PROCESSOR, (Object)parametersProcessor, (Object)POLICY_OPERATION_OPERATION_EXEC_FUNCTION, (Object)operationExecutionFunction, (Object)POLICY_OPERATION_CHILD_CTX, (Object)operationEvent.getContext(), (Object)POLICY_OPERATION_CALLER_SINK, callerSink));
    }

    private static BaseEventContext getStoredChildContext(CoreEvent event) {
        return (BaseEventContext)((InternalEvent)event).getInternalParameter(POLICY_OPERATION_CHILD_CTX);
    }

    public void dispose() {
        this.readWriteLock.withWriteLock(() -> {
            this.policySinks.invalidateAll();
            this.disposed.set(true);
        });
    }

    private final class OperationWithPoliciesFluxObjectFactory
    implements Supplier<FluxSink<CoreEvent>> {
        private OperationWithPoliciesFluxObjectFactory() {
        }

        @Override
        public FluxSink<CoreEvent> get() {
            FluxSinkRecorder sinkRef = new FluxSinkRecorder();
            Flux policyFlux = Flux.create(sinkRef).transform((Function)CompositeOperationPolicy.this.getExecutionProcessor()).doOnNext(result -> {
                BaseEventContext childContext = CompositeOperationPolicy.getStoredChildContext(result);
                if (!childContext.isComplete()) {
                    childContext.success((CoreEvent)result);
                }
                ((MonoSink)((InternalEvent)result).getInternalParameter(CompositeOperationPolicy.POLICY_OPERATION_CALLER_SINK)).success((Object)EventQuickCopy.quickCopy((EventContext)childContext.getParentContext().get(), result));
            }).onErrorContinue(MessagingException.class, (t, e) -> {
                MessagingException me = (MessagingException)((Object)((Object)t));
                me.setProcessedEvent(EventQuickCopy.quickCopy((EventContext)CompositeOperationPolicy.getStoredChildContext(me.getEvent()).getParentContext().get(), me.getEvent()));
                ((MonoSink)((InternalEvent)me.getEvent()).getInternalParameter(CompositeOperationPolicy.POLICY_OPERATION_CALLER_SINK)).error((Throwable)((Object)me));
            });
            policyFlux.subscribe();
            return sinkRef.getFluxSink();
        }
    }
}

