/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class StreamPerThreadSink
implements Sink,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamPerThreadSink.class);
    private final ReactiveProcessor processor;
    private final Consumer<CoreEvent> eventConsumer;
    private final FlowConstruct flowConstruct;
    private volatile boolean disposing = false;
    private final Cache<Thread, FluxSink<CoreEvent>> sinks = Caffeine.newBuilder().weakKeys().build();

    public StreamPerThreadSink(ReactiveProcessor processor, Consumer<CoreEvent> eventConsumer, FlowConstruct flowConstruct) {
        this.processor = processor;
        this.eventConsumer = eventConsumer;
        this.flowConstruct = flowConstruct;
    }

    @Override
    public void accept(CoreEvent event) {
        if (this.disposing) {
            throw new IllegalStateException("Already disposed");
        }
        ((FluxSink)this.sinks.get((Object)Thread.currentThread(), t -> {
            FluxSinkRecorder recorder = new FluxSinkRecorder();
            Flux.create(recorder).doOnNext(request -> this.eventConsumer.accept((CoreEvent)request)).transform((Function)this.processor).subscribe(null, e -> this.sinks.invalidate((Object)Thread.currentThread()), () -> this.sinks.invalidate((Object)Thread.currentThread()));
            return recorder.getFluxSink();
        })).next((Object)event);
    }

    @Override
    public boolean emit(CoreEvent event) {
        this.accept(event);
        return true;
    }

    public void dispose() {
        this.disposing = true;
        this.sinks.asMap().values().forEach(sink -> sink.complete());
        long shutdownTimeout = this.flowConstruct.getMuleContext().getConfiguration().getShutdownTimeout();
        long startMillis = System.currentTimeMillis();
        while (!this.sinks.asMap().isEmpty() && System.currentTimeMillis() - startMillis > shutdownTimeout && !Thread.currentThread().isInterrupted()) {
            Thread.yield();
        }
        if (Thread.currentThread().isInterrupted()) {
            LOGGER.warn("Subscribers of ProcessingStrategy for flow '{}' not completed before thread interruption", (Object)this.flowConstruct.getName());
            this.sinks.invalidateAll();
        } else if (!this.sinks.asMap().isEmpty()) {
            LOGGER.warn("Subscribers of ProcessingStrategy for flow '{}' not completed in {} ms", (Object)this.flowConstruct.getName(), (Object)shutdownTimeout);
            this.sinks.invalidateAll();
        }
    }
}

