/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProactorStreamEmitterProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ReactorStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.StreamPerThreadSink;
import org.mule.runtime.core.internal.processor.strategy.TransactionAwareProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.TransactionalDelegateSink;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransactionAwareProactorStreamEmitterProcessingStrategyFactory
extends ReactorStreamProcessingStrategyFactory
implements TransactionAwareProcessingStrategyFactory {
    private final boolean policyMode;

    public TransactionAwareProactorStreamEmitterProcessingStrategyFactory() {
        this(false);
    }

    public TransactionAwareProactorStreamEmitterProcessingStrategyFactory(boolean policyMode) {
        this.policyMode = policyMode;
    }

    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        TransactionAwareProactorStreamEmitterProcessingStrategy ps = new TransactionAwareProactorStreamEmitterProcessingStrategy(this.getBufferSize(), this.getSubscriberCount(), () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name())), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), this.resolveParallelism(), this.getMaxConcurrency(), this.isMaxConcurrencyEagerCheck(), muleContext.getConfiguration().isThreadLoggingEnabled());
        ps.setPolicyMode(this.policyMode);
        return ps;
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return TransactionAwareProactorStreamEmitterProcessingStrategy.class;
    }

    static class TransactionAwareProactorStreamEmitterProcessingStrategy
    extends ProactorStreamEmitterProcessingStrategyFactory.ProactorStreamEmitterProcessingStrategy {
        TransactionAwareProactorStreamEmitterProcessingStrategy(int bufferSize, int subscriberCount, Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, int parallelism, int maxConcurrency, boolean isMaxConcurrencyEagerCheck, boolean isThreadLoggingEnabled) {
            super(bufferSize, subscriberCount, cpuLightSchedulerSupplier, blockingSchedulerSupplier, cpuIntensiveSchedulerSupplier, parallelism, maxConcurrency, isMaxConcurrencyEagerCheck, isThreadLoggingEnabled);
        }

        TransactionAwareProactorStreamEmitterProcessingStrategy(int bufferSize, int subscriberCount, Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, int maxConcurrency, boolean isMaxConcurrencyEagerCheck) {
            super(bufferSize, subscriberCount, cpuLightSchedulerSupplier, blockingSchedulerSupplier, cpuIntensiveSchedulerSupplier, AbstractStreamProcessingStrategyFactory.CORES, maxConcurrency, isMaxConcurrencyEagerCheck, false);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            Sink proactorSink = super.createSink(flowConstruct, pipeline);
            StreamPerThreadSink syncSink = new StreamPerThreadSink(pipeline, this.createOnEventConsumer(), flowConstruct);
            return new TransactionalDelegateSink(syncSink, proactorSink);
        }

        @Override
        protected Consumer<CoreEvent> createOnEventConsumer() {
            return event -> {};
        }

        @Override
        protected ReactiveProcessor onNonBlockingProcessorTxAware(ReactiveProcessor processor) {
            if (TransactionAwareProcessingStrategyFactory.LAZY_TX_CHECK) {
                return publisher -> Flux.from((Publisher)publisher).flatMap(event -> Mono.just((Object)event).transform((Function)(TransactionCoordination.isTransactionActive() ? BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onProcessor(processor) : processor)));
            }
            return super.onNonBlockingProcessorTxAware(processor);
        }

        @Override
        protected ExecutorService decorateScheduler(Scheduler scheduler) {
            return new ConditionalExecutorServiceDecorator(scheduler, currentScheduler -> TransactionCoordination.isTransactionActive());
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            return !TransactionAwareProcessingStrategyFactory.LAZY_TX_CHECK && TransactionCoordination.isTransactionActive() ? BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onPipeline(pipeline) : super.onPipeline(pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            return !TransactionAwareProcessingStrategyFactory.LAZY_TX_CHECK && TransactionCoordination.isTransactionActive() ? BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onProcessor(processor) : super.onProcessor(processor);
        }
    }
}

