/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.thread.notification.ThreadLoggingExecutorServiceDecorator;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamWorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.WorkQueueProcessor;
import reactor.core.scheduler.Schedulers;

public class WorkQueueStreamProcessingStrategyFactory
extends AbstractStreamWorkQueueProcessingStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkQueueStreamProcessingStrategyFactory.class);

    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new WorkQueueStreamProcessingStrategy(this.getRingBufferSchedulerSupplier(muleContext, schedulersNamePrefix), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), this.getMaxConcurrency(), this.isMaxConcurrencyEagerCheck(), muleContext.getConfiguration().isThreadLoggingEnabled());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return WorkQueueStreamProcessingStrategy.class;
    }

    protected static enum WaitStrategy {
        BLOCKING(reactor.util.concurrent.WaitStrategy.blocking()),
        LITE_BLOCKING(reactor.util.concurrent.WaitStrategy.liteBlocking()),
        SLEEPING(reactor.util.concurrent.WaitStrategy.sleeping()),
        BUSY_SPIN(reactor.util.concurrent.WaitStrategy.busySpin()),
        YIELDING(reactor.util.concurrent.WaitStrategy.yielding()),
        PARKING(reactor.util.concurrent.WaitStrategy.parking()),
        PHASED(reactor.util.concurrent.WaitStrategy.phasedOffLiteLock((long)200L, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS));

        private final reactor.util.concurrent.WaitStrategy reactorWaitStrategy;

        private WaitStrategy(reactor.util.concurrent.WaitStrategy reactorWaitStrategy) {
            this.reactorWaitStrategy = reactorWaitStrategy;
        }

        reactor.util.concurrent.WaitStrategy getReactorWaitStrategy() {
            return this.reactorWaitStrategy;
        }
    }

    private static final class EventWrapper {
        CoreEvent wrappedEvent;

        public EventWrapper(CoreEvent event) {
            this.wrappedEvent = event;
            ((BaseEventContext)this.wrappedEvent.getContext()).getRootContext().onTerminated((e, t) -> {
                this.wrappedEvent = null;
            });
        }

        public CoreEvent getWrappedEvent() {
            return this.wrappedEvent;
        }
    }

    static class WorkQueueStreamProcessingStrategy
    extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
    implements Startable,
    Stoppable {
        private final int bufferSize;
        private final Supplier<Scheduler> ringBufferSchedulerSupplier;
        private final Supplier<Scheduler> blockingSchedulerSupplier;
        private final WaitStrategy waitStrategy;
        private Scheduler blockingScheduler;
        private final List<Sink> sinkList = new ArrayList<Sink>();
        private final boolean isThreadLoggingEnabled;

        protected WorkQueueStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<Scheduler> blockingSchedulerSupplier, int maxConcurrency, boolean maxConcurrencyEagerCheck, boolean isThreadLoggingEnabled) {
            super(subscribers, maxConcurrency, maxConcurrencyEagerCheck);
            this.bufferSize = Objects.requireNonNull(bufferSize);
            this.ringBufferSchedulerSupplier = Objects.requireNonNull(ringBufferSchedulerSupplier);
            this.blockingSchedulerSupplier = Objects.requireNonNull(blockingSchedulerSupplier);
            this.waitStrategy = WaitStrategy.valueOf(waitStrategy);
            this.isThreadLoggingEnabled = isThreadLoggingEnabled;
        }

        protected WorkQueueStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<Scheduler> blockingSchedulerSupplier, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
            this(ringBufferSchedulerSupplier, bufferSize, subscribers, waitStrategy, blockingSchedulerSupplier, maxConcurrency, maxConcurrencyEagerCheck, false);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor function) {
            long shutdownTimeout = flowConstruct.getMuleContext().getConfiguration().getShutdownTimeout();
            WorkQueueProcessor processor = WorkQueueProcessor.builder().executor((ExecutorService)this.ringBufferSchedulerSupplier.get()).bufferSize(this.bufferSize).waitStrategy(this.waitStrategy.getReactorWaitStrategy()).build();
            int subscriberCount = this.maxConcurrency < this.subscribers ? this.maxConcurrency : this.subscribers;
            CountDownLatch completionLatch = new CountDownLatch(subscriberCount);
            for (int i = 0; i < subscriberCount; ++i) {
                processor.doOnSubscribe(subscription -> Thread.currentThread().setContextClassLoader(this.executionClassloader)).map(EventWrapper::getWrappedEvent).transform((Function)function).subscribe(null, e -> completionLatch.countDown(), completionLatch::countDown);
            }
            if (!processor.hasDownstreams()) {
                processor.forceShutdown();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"No subscriptions active for processor."));
            }
            if (processor.downstreamCount() < (long)subscriberCount) {
                processor.forceShutdown();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Not enough subscriptions active for processor."));
            }
            return this.buildSink(processor.sink(FluxSink.OverflowStrategy.BUFFER), () -> {
                long start = System.currentTimeMillis();
                if (!processor.awaitAndShutdown(Duration.ofMillis(shutdownTimeout))) {
                    LOGGER.warn("WorkQueueProcessor of ProcessingStrategy for flow '{}' not shutDown in {} ms. Forcing shutdown...", (Object)flowConstruct.getName(), (Object)shutdownTimeout);
                    processor.forceShutdown();
                }
                this.awaitSubscribersCompletion(flowConstruct, shutdownTimeout, completionLatch, start);
            }, this.createOnEventConsumer(), this.bufferSize);
        }

        protected <E> AbstractProcessingStrategy.ReactorSink<E> buildSink(FluxSink<E> fluxSink, Disposable disposable, Consumer<CoreEvent> onEventConsumer, int bufferSize) {
            return new AbstractProcessingStrategy.DefaultReactorSink(fluxSink, disposable, onEventConsumer, bufferSize){

                @Override
                public EventWrapper intoSink(CoreEvent event) {
                    return new EventWrapper(event);
                }
            };
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            if (this.maxConcurrency > this.subscribers) {
                if (this.isThreadLoggingEnabled) {
                    return publisher -> Flux.from((Publisher)publisher).flatMap(event -> Mono.subscriberContext().flatMap(ctx -> Mono.just((Object)event).transform((Function)pipeline).subscribeOn(Schedulers.fromExecutorService((ExecutorService)new ThreadLoggingExecutorServiceDecorator(ctx.getOrEmpty((Object)"mule.nb.ThreadNotificationLogger"), this.decorateScheduler(this.blockingScheduler), event.getContext().getId())))));
                }
                return publisher -> Flux.from((Publisher)publisher).flatMap(event -> Flux.just((Object)event).transform((Function)pipeline).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.blockingScheduler))).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)this.blockingScheduler)), this.maxConcurrency);
            }
            return super.onPipeline(pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.blockingScheduler)));
            }
            return super.onProcessor(processor);
        }

        public void start() throws MuleException {
            this.blockingScheduler = this.blockingSchedulerSupplier.get();
        }

        public void stop() throws MuleException {
            this.sinkList.stream().filter(sink -> sink instanceof org.mule.runtime.api.lifecycle.Disposable).forEach(sink -> ((org.mule.runtime.api.lifecycle.Disposable)sink).dispose());
            if (this.blockingScheduler != null) {
                this.blockingScheduler.stop();
            }
        }
    }
}

