/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;

public abstract class ManagedCursorProvider<T extends Cursor>
implements CursorProvider<T> {
    private final CursorProvider<T> delegate;
    private final Set<Cursor> cursors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MutableStreamingStatistics statistics;
    private final CursorProviderJanitor janitor;

    protected ManagedCursorProvider(CursorProvider<T> delegate, MutableStreamingStatistics statistics) {
        this.delegate = delegate;
        this.janitor = new CursorProviderJanitor(delegate, this.cursors, statistics);
        this.statistics = statistics;
        statistics.incrementOpenProviders();
    }

    public final T openCursor() {
        Cursor cursor = this.delegate.openCursor();
        Cursor managedCursor = this.managedCursor(cursor);
        this.cursors.add(managedCursor);
        this.statistics.incrementOpenCursors();
        return (T)managedCursor;
    }

    public final void onClose(Cursor cursor) {
        if (this.cursors.remove(cursor) && this.isClosed() && this.cursors.isEmpty()) {
            this.releaseResources();
        }
    }

    protected abstract T managedCursor(T var1);

    public final void releaseResources() {
        this.janitor.releaseResources();
    }

    public CursorProviderJanitor getJanitor() {
        return this.janitor;
    }

    public void close() {
        this.janitor.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }
}

