/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.io.IOException;
import java.util.function.Consumer;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;

class ManagedCursorIterator<T>
implements CursorIterator<T> {
    private final CursorIterator<T> delegate;
    private final CursorProviderJanitor janitor;

    ManagedCursorIterator(CursorIterator<T> delegate, CursorProviderJanitor janitor) {
        this.delegate = delegate;
        this.janitor = janitor;
    }

    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            this.janitor.releaseCursor((Cursor)this.delegate);
        }
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public T next() {
        return (T)this.delegate.next();
    }

    public void remove() {
        this.delegate.remove();
    }

    public void forEachRemaining(Consumer<? super T> action) {
        this.delegate.forEachRemaining(action);
    }

    public long getPosition() {
        return this.delegate.getPosition();
    }

    public void seek(long position) throws IOException {
        this.delegate.seek(position);
    }

    public void release() {
        this.delegate.release();
    }

    public boolean isReleased() {
        return this.delegate.isReleased();
    }

    public CursorProvider getProvider() {
        return this.delegate.getProvider();
    }

    public int getSize() {
        return this.delegate.getSize();
    }
}

