/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.lexer;

import org.mulesoft.lexer.LexerInput$;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.package$;

public final class YamlCharRules$ {
    public static YamlCharRules$ MODULE$;

    static {
        new YamlCharRules$();
    }

    public boolean isCPrintable(int c) {
        return c == 9 || c == 10 || c == 13 || c >= 32 && c <= 126 || c == 133 || c >= 160 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF;
    }

    public boolean isNbJson(int c) {
        return c == 9 || c >= 32 && c <= 0x10FFFF;
    }

    public final int BomMark() {
        return 65279;
    }

    public boolean isIndicator(int c) {
        return "-?:,[]{}#&*!|>'\"%@ `".indexOf(c) != -1;
    }

    public boolean isFirstDiscriminators(char c) {
        return "?:-".indexOf(c) != -1;
    }

    public boolean isFlowIndicator(int chr) {
        return chr == 91 || chr == 93 || chr == 123 || chr == 125 || chr == 44;
    }

    public boolean isCharPreceding(char prev, char c) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(9).append("[^\\s\\\\]").append(c).append(".*").toString())).r().pattern().matcher(package$.MODULE$.StringBuilder().newBuilder().append(prev).append(c).mkString()).matches();
    }

    public boolean isCharFollowedBy(char c, char next) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(9).append(".*").append(this.escape(c)).append("[^\\s\\\\]").toString())).r().pattern().matcher(package$.MODULE$.StringBuilder().newBuilder().append(c).append(next).mkString()).matches();
    }

    private String escape(char c) {
        String string;
        char c2 = c;
        switch (c2) {
            case '?': {
                string = "\\?";
                break;
            }
            default: {
                string = package$.MODULE$.StringBuilder().newBuilder().append(c).mkString();
                break;
            }
        }
        return string;
    }

    public final boolean isBBreak(int c) {
        return c == 10 || c == 13;
    }

    public final boolean isBreakOrEof(int c) {
        return c == 10 || c == 13 || c == LexerInput$.MODULE$.EofChar();
    }

    public boolean isNBChar(int c) {
        return this.isCPrintable(c) && !this.isBBreak(c) && c != 65279;
    }

    public boolean isWhite(int c) {
        return c == 32 || c == 9;
    }

    public boolean isNsChar(int c) {
        return this.isNBChar(c) && !this.isWhite(c);
    }

    public boolean isNsDecDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public boolean isNsHexDigit(int c) {
        return this.isNsDecDigit(c) || c >= 65 && c <= 70 || c >= 97 && c <= 102;
    }

    public boolean isAsciiLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public boolean isWordChar(int c) {
        return this.isNsDecDigit(c) || this.isAsciiLetter(c) || c == 45;
    }

    public boolean isBreakComment(int c) {
        return this.isBreakOrEof(c);
    }

    public boolean isMappingIndicator(int c1, Function0<Object> c2) {
        return c1 == 58 && (this.isWhite(c2.apply$mcI$sp()) || this.isBreakComment(c2.apply$mcI$sp()));
    }

    public int escapeSeq(int c) {
        int n;
        int n2 = c;
        switch (n2) {
            case 48: {
                n = 0;
                break;
            }
            case 97: {
                n = 7;
                break;
            }
            case 98: {
                n = 11;
                break;
            }
            case 9: 
            case 116: {
                n = 9;
                break;
            }
            case 110: {
                n = 10;
                break;
            }
            case 118: {
                n = 11;
                break;
            }
            case 102: {
                n = 12;
                break;
            }
            case 114: {
                n = 13;
                break;
            }
            case 101: {
                n = 27;
                break;
            }
            case 32: {
                n = 32;
                break;
            }
            case 34: {
                n = 34;
                break;
            }
            case 47: {
                n = 47;
                break;
            }
            case 92: {
                n = 92;
                break;
            }
            case 78: {
                n = 133;
                break;
            }
            case 95: {
                n = 160;
                break;
            }
            case 76: {
                n = 8232;
                break;
            }
            case 80: {
                n = 8233;
                break;
            }
            case 120: {
                n = 120;
                break;
            }
            case 117: {
                n = 117;
                break;
            }
            case 85: {
                n = 85;
                break;
            }
            default: {
                n = -1;
                break;
            }
        }
        return n;
    }

    private YamlCharRules$() {
        MODULE$ = this;
    }
}

