/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import java.io.Serializable;
import org.mule.weave.v2.exception.IndexOutOfBoundsException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.csv.reader.parser.CSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.CSVParser;
import org.mule.weave.v2.module.csv.reader.parser.CSVRecord;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import org.mule.weave.v2.module.csv.reader.parser.CsvEntryToken$;
import org.mule.weave.v2.module.csv.reader.parser.CsvTokenHelper$;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVRecordLocation;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001M\u0011\u0001#\u00138eKb,GmQ*W!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011A\u00029beN,'O\u0003\u0002\u0006\r\u00051!/Z1eKJT!a\u0002\u0005\u0002\u0007\r\u001chO\u0003\u0002\n\u0015\u00051Qn\u001c3vY\u0016T!a\u0003\u0007\u0002\u0005Y\u0014$BA\u0007\u000f\u0003\u00159X-\u0019<f\u0015\ty\u0001#\u0001\u0003nk2,'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%\u00195K\u0016)beN,'\u000f\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001b\u00031\u0019x.\u001e:dKJ+\u0017\rZ3s+\u0005Y\u0002C\u0001\u000f\u001f\u001b\u0005i\"BA\u0003\t\u0013\tyRD\u0001\u0007T_V\u00148-\u001a*fC\u0012,'\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001c\u00035\u0019x.\u001e:dKJ+\u0017\rZ3sA!I1\u0005\u0001B\u0001B\u0003%AeJ\u0001\fGN36+\u001a;uS:<7\u000f\u0005\u0002\u0016K%\u0011aE\u0001\u0002\f\u0007N36+\u001a;uS:<7/\u0003\u0002)-\u0005Y1m\u001d<TKR$\u0018N\\4t\u0011!Q\u0003A!A!\u0002\u0017Y\u0013aA2uqB\u0011AfL\u0007\u0002[)\u0011aFC\u0001\u0006[>$W\r\\\u0005\u0003a5\u0012\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q\u0019Ag\u000e\u001d\u0015\u0005U2\u0004CA\u000b\u0001\u0011\u0015Q\u0013\u0007q\u0001,\u0011\u0015I\u0012\u00071\u0001\u001c\u0011\u0015\u0019\u0013\u00071\u0001%\u0011\u001dQ\u0004A1A\u0005\u0002m\nAB]3d_J$Gk\\6f]N,\u0012\u0001\u0010\t\u00039uJ!AP\u000f\u0003!\u0011+g-Y;mi2{gnZ!se\u0006L\bB\u0002!\u0001A\u0003%A(A\u0007sK\u000e|'\u000f\u001a+pW\u0016t7\u000f\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0003)\u00197O^#oiJLWm]\u000b\u0002\tB\u0011Q)S\u0007\u0002\r*\u0011Qa\u0012\u0006\u0003\u0011\"\t1\u0001_7m\u0013\tQeI\u0001\u0006U_.,g.\u0011:sCfDa\u0001\u0014\u0001!\u0002\u0013!\u0015aC2tm\u0016sGO]5fg\u0002BqA\u0014\u0001A\u0002\u0013\u0005q*\u0001\u0005m_\u000e\fG/[8o+\u0005\u0001\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&\u0001\u0002'p]\u001eDqa\u0016\u0001A\u0002\u0013\u0005\u0001,\u0001\u0007m_\u000e\fG/[8o?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011\u0011KW\u0005\u00037J\u0013A!\u00168ji\"9QLVA\u0001\u0002\u0004\u0001\u0016a\u0001=%c!1q\f\u0001Q!\nA\u000b\u0011\u0002\\8dCRLwN\u001c\u0011\t\u000b\u0005\u0004A\u0011\u00012\u0002\u0011\r|g\u000e^1j]N$\"a\u00194\u0011\u0005E#\u0017BA3S\u0005\u001d\u0011un\u001c7fC:DQa\u001a1A\u0002!\fQ!\u001b8eKb\u0004\"!U5\n\u0005)\u0014&aA%oi\")A\u000e\u0001C\u0001[\u0006\u0019q-\u001a;\u0015\u00059\f\bCA\u000bp\u0013\t\u0001(AA\u0005D'Z\u0013VmY8sI\")qm\u001ba\u0001Q\")1\u000f\u0001C\u0001i\u0006A1o[5q\u0019&tW\rF\u0001Z\u0011\u00151\b\u0001\"\u0003x\u0003%)G.Z7f]R\fE\u000fF\u0002y\u0003+\u00012!U=|\u0013\tQ(K\u0001\u0004PaRLwN\u001c\t\u0006y\u0006%\u0011q\u0002\b\u0004{\u0006\u0015ab\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002I\ta\u0001\u0010:p_Rt\u0014\"A*\n\u0007\u0005\u001d!+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0011Q\u0002\u0002\u0004'\u0016\f(bAA\u0004%B\u0019Q#!\u0005\n\u0007\u0005M!AA\bJ]\u0012,\u00070\u001a3D'Z+e\u000e\u001e:z\u0011\u00159W\u000f1\u0001i\u0011\u001d\tI\u0002\u0001C\u0005\u00037\t\u0011\u0002]1sg\u0016tU\r\u001f;\u0015\u0003aDq!a\b\u0001\t\u0003\t\t#A\u000bqe>\u001cWm]:O_:\fVo\u001c;fI\u0016sGO]=\u0015\u0005\u0005\r\u0002CB)\u0002&\u0005=1-C\u0002\u0002(I\u0013a\u0001V;qY\u0016\u0014\u0004bBA\u0016\u0001\u0011\u0005\u0011\u0011E\u0001\u0013aJ|7-Z:t#V|G/\u001a3F]R\u0014\u0018\u0010C\u0004\u00020\u0001!\t!!\r\u0002\u0017\r\u0014X-\u0019;f\u000b:$(/\u001f\u000b\u0007\u0003\u001f\t\u0019$a\u000e\t\u000f\u0005U\u0012Q\u0006a\u0001!\u0006Qa/\u00197vK&sG-\u001a=\t\u000f\u0005e\u0012Q\u0006a\u0001G\u0006A\u0011n])v_R,G\rC\u0004\u00020\u0001!\t!!\u0010\u0015\u0011\u0005=\u0011qHA!\u0003\u000bBq!!\u000e\u0002<\u0001\u0007\u0001\u000bC\u0004\u0002D\u0005m\u0002\u0019\u0001)\u0002\tML'0\u001a\u0005\b\u0003s\tY\u00041\u0001d\u0001")
public class IndexedCSVParser
extends CSVParser {
    private final SourceReader sourceReader;
    private final DefaultLongArray recordTokens;
    private final TokenArray csvEntries;
    private long location;

    @Override
    public SourceReader sourceReader() {
        return this.sourceReader;
    }

    public DefaultLongArray recordTokens() {
        return this.recordTokens;
    }

    public TokenArray csvEntries() {
        return this.csvEntries;
    }

    public long location() {
        return this.location;
    }

    public void location_$eq(long x$1) {
        this.location = x$1;
    }

    public boolean contains(int index) {
        return this.recordTokens().size() > (long)index ? true : this.elementAt(index).isDefined();
    }

    public CSVRecord get(int index) {
        Option<Seq<IndexedCSVEntry>> parsed = this.elementAt(index);
        if (!parsed.isDefined()) {
            throw new IndexOutOfBoundsException((Location)UnknownLocation$.MODULE$, (long)index, this.recordTokens().size());
        }
        return new CSVRecord((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.headers(), this.headersWithIndex(), new IndexedCSVRecordLocation((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.sourceReader()));
    }

    @Override
    public void skipLine() {
        this.sourceReader().seek(this.location());
        char next = this.sourceReader().lookAheadAscii();
        if (next != '\uffff') {
            char value = this.sourceReader().readAscii();
            while (next != '\uffff' && value != '\n' && (value != '\r' || next == '\n')) {
                value = this.sourceReader().readAscii();
                next = this.sourceReader().lookAheadAscii();
                this.location_$eq(this.sourceReader().position());
            }
        }
    }

    private Option<Seq<IndexedCSVEntry>> elementAt(int index) {
        None$ none$;
        long size;
        if (this.headers().length == 0) {
            Option<Seq<IndexedCSVEntry>> headerParsing;
            boolean hasHeaderLine;
            int headerLine = super.csvSettings().headerLineNumber();
            boolean bl = hasHeaderLine = headerLine > 0;
            if (hasHeaderLine) {
                this.skipLines(headerLine - 1);
            }
            if (super.csvSettings().header() && (headerParsing = this.parseNext()).isDefined()) {
                this.processHeaders((Seq<? extends CSVEntry>)((Seq)headerParsing.get()));
            }
            this.skipLines(this.linesToSkipBeforeBody());
        }
        if ((size = this.recordTokens().size()) <= (long)index) {
            for (long remaining = (long)index - size; remaining >= 0L; --remaining) {
                Option<Seq<IndexedCSVEntry>> nextRecordMaybe = this.parseNext();
                if (!nextRecordMaybe.isDefined()) continue;
                Seq nextRecord = (Seq)nextRecordMaybe.get();
                long recordOffset = this.csvEntries().length();
                int numOfColumns = nextRecord.length();
                long recordToken = CsvTokenHelper$.MODULE$.createRecordToken(recordOffset, numOfColumns);
                this.recordTokens().$plus$eq(recordToken);
                this.csvEntries().$plus$plus$eq((Seq<long[]>)((Seq)nextRecord.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.token(), Seq$.MODULE$.canBuildFrom())));
                if (remaining != 0L) continue;
                return new Some((Object)nextRecord);
            }
            none$ = None$.MODULE$;
        } else {
            long recordToken = this.recordTokens().apply((long)index);
            IndexedCSVEntry[] record = CsvTokenHelper$.MODULE$.getRecord(recordToken, this.csvEntries(), this.sourceReader(), this.helper());
            none$ = new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])record));
        }
        return none$;
    }

    private Option<Seq<IndexedCSVEntry>> parseNext() {
        None$ none$;
        block3: {
            block2: {
                ArrayBuffer recordEntries;
                do {
                    this.sourceReader().seek(this.location());
                    recordEntries = new ArrayBuffer();
                    char value = this.sourceReader().lookAheadAscii();
                    if (value == '\uffff') break block2;
                    boolean recordFinished = false;
                    while (!recordFinished) {
                        Tuple2<IndexedCSVEntry, Object> quotedEntry = this.processNonQuotedEntry();
                        recordEntries.$plus$eq(quotedEntry._1());
                        recordFinished = quotedEntry._2$mcZ$sp();
                    }
                    this.location_$eq(this.sourceReader().position());
                } while (super.csvSettings().ignoreEmptyLine() && recordEntries.length() == 1 && ((IndexedCSVEntry)recordEntries.apply(0)).length() == 0L);
                none$ = new Some((Object)recordEntries);
                break block3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processNonQuotedEntry() {
        void var1_1;
        Tuple2 result = null;
        boolean isBlank = true;
        long valueIndex = this.sourceReader().position();
        boolean isQuoted = false;
        while (result == null) {
            Object object;
            char next = this.read();
            if (this.isQuoteChar(next) && isBlank) {
                result = this.processQuotedEntry();
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEscapeChar(next) && this.requiresEscape(this.sourceReader().lookAheadAscii())) {
                char c = this.read();
                if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c))) {
                    isBlank = false;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isColumnSeparator(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEndOfInput(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, this.sourceReader().position() - valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isLineEnding(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                if (next == '\r' && this.sourceReader().lookAheadAscii() == '\n') {
                    object = BoxesRunTime.boxToCharacter((char)this.sourceReader().readAscii());
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(next))) {
                isBlank = false;
            }
            object = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processQuotedEntry() {
        void var3_2;
        long valueIndex = this.sourceReader().position();
        Tuple2 result = null;
        boolean isQuoted = true;
        while (result == null) {
            Character c;
            char next = this.read();
            long size = this.sourceReader().previousPosition() - valueIndex;
            if (this.isEscapeChar(next) && this.requiresEscapeInQuoted(this.sourceReader().lookAheadAscii())) {
                c = BoxesRunTime.boxToCharacter((char)this.read());
                continue;
            }
            if (this.isQuoteChar(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, size, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)this.consumeUntilEndOfEntry()));
            } else if (this.isEndOfInput(next)) {
                this.logInvalidEndOfString();
                long newSize = this.sourceReader().position() - valueIndex;
                result = new Tuple2((Object)this.createEntry(valueIndex, newSize < 0L ? 0L : newSize, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            c = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public IndexedCSVEntry createEntry(long valueIndex, boolean isQuoted) {
        return this.createEntry(valueIndex, this.sourceReader().previousPosition() - valueIndex, isQuoted);
    }

    public IndexedCSVEntry createEntry(long valueIndex, long size, boolean isQuoted) {
        long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size, isQuoted);
        return new IndexedCSVEntry(token, this.sourceReader(), this.helper());
    }

    public IndexedCSVParser(SourceReader sourceReader, CSVSettings cSVSettings, EvaluationContext ctx) {
        this.sourceReader = sourceReader;
        super(cSVSettings, ctx);
        this.recordTokens = (DefaultLongArray)ctx.registerCloseable((AutoCloseable)new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1()));
        this.csvEntries = (TokenArray)ctx.registerCloseable((AutoCloseable)new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1()));
        this.location = 0L;
    }
}

