/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.connection.CachedConnectionHandler;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;

final class CachedConnectionManagementStrategy<C>
extends ConnectionManagementStrategy<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedConnectionManagementStrategy.class);
    private final Lock connectionLock = new ReentrantLock();
    private LazyValue<ConnectionHandlerAdapter<C>> connectionHandler;

    CachedConnectionManagementStrategy(ConnectionProvider<C> connectionProvider, MuleContext muleContext) {
        super(connectionProvider, muleContext);
        this.lazyConnect();
    }

    @Override
    public ConnectionHandler<C> getConnectionHandler() throws ConnectionException {
        try {
            return (ConnectionHandler)this.connectionHandler.get();
        }
        catch (Throwable t) {
            t = Exceptions.unwrap((Throwable)t);
            if (t instanceof ConnectionException) {
                throw (ConnectionException)t;
            }
            throw new ConnectionException(t.getMessage(), t);
        }
    }

    @Override
    public void close() throws MuleException {
        this.connectionHandler.ifComputed(this::close);
    }

    private synchronized void lazyConnect() {
        ConcurrencyUtils.withLock(this.connectionLock, () -> {
            this.connectionHandler = new LazyValue(this::createConnection);
        });
    }

    private ConnectionHandlerAdapter<C> createConnection() throws ConnectionException {
        LifecycleUtils.assertNotStopping(this.muleContext, "Mule is shutting down... Cannot establish new connections");
        return new CachedConnectionHandler<Object>(this.connectionProvider.connect(), this::invalidate, this.connectionProvider);
    }

    private void close(ConnectionHandlerAdapter<C> connectionHandler) {
        try {
            connectionHandler.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing cached connection", (Throwable)e);
        }
    }

    private void invalidate(ConnectionHandlerAdapter<C> connection) {
        try {
            this.close(connection);
        }
        finally {
            ConcurrencyUtils.withLock(this.connectionLock, () -> this.lazyConnect());
        }
    }
}

