/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.serialization.AbstractSerializationProtocol;
import org.mule.runtime.core.internal.util.SerializationUtils;

public class JavaExternalSerializerProtocol
extends AbstractSerializationProtocol {
    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        block15: {
            if (object instanceof CursorStreamProvider) {
                try (CursorStream cursor = (CursorStream)((CursorStreamProvider)object).openCursor();){
                    this.doSerialize(IOUtils.toByteArray((InputStream)cursor), out);
                    break block15;
                }
                catch (IOException e) {
                    throw new SerializationException(I18nMessageFactory.createStaticMessage((String)"Could not serialize cursor stream"), (Throwable)e);
                }
            }
            this.doSerialize(object, out);
        }
    }

    private void doSerialize(Object object, OutputStream out) {
        this.validateForSerialization(object);
        org.apache.commons.lang3.SerializationUtils.serialize((Serializable)((Serializable)object), (OutputStream)out);
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        if (object instanceof CursorStreamProvider) {
            try (CursorStream cursor = (CursorStream)((CursorStreamProvider)object).openCursor();){
                byte[] byArray = org.apache.commons.lang3.SerializationUtils.serialize((Serializable)IOUtils.toByteArray((InputStream)cursor));
                return byArray;
            }
        }
        this.validateForSerialization(object);
        return org.apache.commons.lang3.SerializationUtils.serialize((Serializable)((Serializable)object));
    }

    @Override
    protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (String)"Cannot deserialize a null stream");
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"Cannot deserialize with a null classloader");
        return (T)SerializationUtils.deserialize(inputStream, classLoader, this.muleContext);
    }

    @Override
    protected <T> T postInitialize(T object) {
        return object;
    }

    private void validateForSerialization(Object object) {
        if (object != null && !(object instanceof Serializable)) {
            throw new SerializationException(String.format("Was expecting a Serializable type. %s was found instead", object.getClass().getName()));
        }
    }
}

