/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.exception.MessageRedeliveredException;
import org.mule.runtime.core.privileged.processor.AbstractRedeliveryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class IdempotentRedeliveryPolicy
extends AbstractRedeliveryPolicy {
    private static final String EXPRESSION_RUNTIME_EXCEPTION_WARN_MSG = "The message cannot be processed because the digest could not be generated. Either make the payload serializable or use an expression.";
    public static final String SECURE_HASH_EXPR_FORMAT = "%%dw 2.0" + System.lineSeparator() + "output text/plain" + System.lineSeparator() + "import dw::Crypto" + System.lineSeparator() + "---" + System.lineSeparator() + "if ((payload.^mimeType startsWith 'application/java') and payload.^class != 'java.lang.String') java!java::util::Objects::hashCode(payload) else Crypto::hashWith(payload.^raw, '%s')";
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentRedeliveryPolicy.class);
    private LockFactory lockFactory;
    private ObjectStoreManager objectStoreManager;
    private ExpressionManager expressionManager;
    private boolean useSecureHash;
    private String messageDigestAlgorithm;
    private String idExpression;
    private ObjectStore<RedeliveryCounter> store;
    private ObjectStore<RedeliveryCounter> privateStore;
    private String idrId;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.useSecureHash && this.idExpression != null) {
            this.useSecureHash = false;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Disabling useSecureHash in idempotent-redelivery-policy since an idExpression has been configured");
            }
        }
        if (!this.useSecureHash && this.messageDigestAlgorithm != null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("The message digest algorithm '%s' was specified when a secure hash will not be used", this.messageDigestAlgorithm)), (Initialisable)this);
        }
        if (!this.useSecureHash && this.idExpression == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure("No method for identifying messages was specified"), (Initialisable)this);
        }
        if (this.useSecureHash) {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = "SHA-256";
            }
            this.idExpression = String.format(SECURE_HASH_EXPR_FORMAT, this.messageDigestAlgorithm);
        }
        this.idrId = String.format("%s-%s-%s", this.muleContext.getConfiguration().getId(), this.getLocation().getRootContainerName(), "idr");
        if (this.store != null && this.privateStore != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Ambiguous definition of object store, both reference and private were configured"), (Initialisable)this);
        }
        if (this.store == null) {
            this.store = this.privateStore == null ? this.internalObjectStoreSupplier().get() : this.privateStore;
        }
        LifecycleUtils.initialiseIfNeeded(this.store, true, this.muleContext);
    }

    private Supplier<ObjectStore> internalObjectStoreSupplier() {
        return () -> this.objectStoreManager.createObjectStore(this.getLocation().getRootContainerName() + "." + this.getClass().getName(), ObjectStoreSettings.builder().persistent(false).entryTtl(Long.valueOf(300000L)).expirationInterval(Long.valueOf(6000L)).build());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (ObjectStoreException e) {
                LOGGER.warn("error closing object store: " + e.getMessage(), (Throwable)e);
            }
            LifecycleUtils.disposeIfNeeded(this.store, LOGGER);
            this.store = null;
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        LifecycleUtils.startIfNeeded(this.store);
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        LifecycleUtils.stopIfNeeded(this.store);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        Optional<Object> exceptionSeen = Optional.empty();
        String messageId = null;
        try {
            messageId = this.getIdForEvent(event);
        }
        catch (ExpressionRuntimeException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn(EXPRESSION_RUNTIME_EXCEPTION_WARN_MSG, (Throwable)((Object)e));
            } else {
                LOGGER.warn(EXPRESSION_RUNTIME_EXCEPTION_WARN_MSG);
            }
            return null;
        }
        catch (Exception ex) {
            exceptionSeen = Optional.of(ex);
        }
        Lock lock = this.lockFactory.createLock(this.idrId + "-" + messageId);
        lock.lock();
        try {
            RedeliveryCounter counter = this.findCounter(messageId);
            if (exceptionSeen.isPresent()) {
                throw new MessageRedeliveredException(messageId, counter.counter.get(), this.maxRedeliveryCount, (Throwable)exceptionSeen.get());
            }
            if (counter != null && counter.counter.get() > this.maxRedeliveryCount) {
                throw new MessageRedeliveredException(messageId, counter.errors, counter.counter.get(), this.maxRedeliveryCount);
            }
            try {
                CoreEvent returnEvent = this.processNext(event);
                counter = this.findCounter(messageId);
                if (counter != null) {
                    this.resetCounter(messageId);
                }
                CoreEvent coreEvent = returnEvent;
                return coreEvent;
            }
            catch (Exception ex) {
                if (ex instanceof MessagingException) {
                    this.incrementCounter(messageId, (MessagingException)((Object)ex));
                    throw ex;
                }
                MessagingException me = this.createMessagingException(event, ex, (Component)this);
                this.incrementCounter(messageId, me);
                throw ex;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        return ReactiveProcessor.ProcessingType.BLOCKING;
    }

    private MessagingException createMessagingException(CoreEvent event, Throwable cause, Component processor) {
        MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(processor);
        MessagingException me = new MessagingException(event, cause, processor);
        return exceptionResolver.resolve(me, this.muleContext);
    }

    private void resetCounter(String messageId) throws ObjectStoreException {
        this.store.remove(messageId);
        this.store.store(messageId, (Serializable)new RedeliveryCounter());
    }

    public RedeliveryCounter findCounter(String messageId) throws ObjectStoreException {
        boolean counterExists = this.store.contains(messageId);
        if (counterExists) {
            return (RedeliveryCounter)this.store.retrieve(messageId);
        }
        return null;
    }

    private RedeliveryCounter incrementCounter(String messageId, MessagingException ex) throws ObjectStoreException {
        RedeliveryCounter counter = this.findCounter(messageId);
        if (counter == null) {
            counter = new RedeliveryCounter();
        } else {
            this.store.remove(messageId);
        }
        counter.counter.incrementAndGet();
        counter.errors.add(ex.getEvent().getError().get());
        this.store.store(messageId, (Serializable)counter);
        return counter;
    }

    private String getIdForEvent(CoreEvent event) {
        return (String)this.expressionManager.evaluate(this.idExpression, DataType.STRING, BindingContextUtils.NULL_BINDING_CONTEXT, event).getValue();
    }

    public boolean isUseSecureHash() {
        return this.useSecureHash;
    }

    public void setUseSecureHash(boolean useSecureHash) {
        this.useSecureHash = useSecureHash;
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public void setObjectStore(ObjectStore<RedeliveryCounter> store) {
        this.store = store;
    }

    public void setPrivateObjectStore(ObjectStore<RedeliveryCounter> store) {
        this.privateStore = store;
    }

    @Inject
    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
    }

    @Inject
    @Named(value="_muleObjectStoreManager")
    public void setObjectStoreManager(ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    @Inject
    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public static class RedeliveryCounter
    implements Serializable {
        private static final long serialVersionUID = 5513487261745816555L;
        private final AtomicInteger counter = new AtomicInteger();
        private final List<Error> errors = new LinkedList<Error>();
    }
}

