/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.rx.FluxSinkRecorderToReactorSinkAdapter;
import org.mule.runtime.core.internal.rx.MonoSinkRecorder;
import org.mule.runtime.core.internal.rx.MonoSinkRecorderToReactorSinkAdapter;
import org.mule.runtime.core.internal.rx.SinkRecorderToReactorSinkAdapter;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class MessageProcessors {
    private static final String WITHIN_PROCESS_WITH_CHILD_CONTEXT = "messageProcessors.withinProcessWithChildContext";
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessors.class);

    private MessageProcessors() {
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, List<Processor> processors) {
        if (processors.size() == 1 && processors.get(0) instanceof MessageProcessorChain) {
            return (MessageProcessorChain)processors.get(0);
        }
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder();
        processingStrategy.ifPresent(defaultMessageProcessorChainBuilder::setProcessingStrategy);
        return defaultMessageProcessorChainBuilder.chain(processors).build();
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, Processor ... processors) {
        return MessageProcessors.newChain(processingStrategy, Arrays.asList(processors));
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor) throws MuleException {
        return MessageProcessors.processToApply(event, processor, false);
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor, boolean completeContext) throws MuleException {
        return MessageProcessors.processToApply(event, processor, completeContext, (Publisher<CoreEvent>)Mono.from(((BaseEventContext)event.getContext()).getResponsePublisher()));
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor, boolean completeContext, Publisher<CoreEvent> alternate) throws MuleException {
        try {
            return (CoreEvent)Mono.just((Object)event).transform((Function)processor).switchIfEmpty(Mono.from(alternate)).doOnSuccess(MessageProcessors.completeSuccessIfNeeded(event.getContext(), completeContext)).doOnError(MessageProcessors.completeErrorIfNeeded(event.getContext(), completeContext)).block();
        }
        catch (Throwable e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    public static CoreEvent processToApplyWithChildContext(CoreEvent event, ReactiveProcessor processor) throws MuleException {
        try {
            return (CoreEvent)Mono.just((Object)event).transform(publisher -> Mono.from((Publisher)publisher).flatMap(request -> Mono.from(MessageProcessors.internalProcessWithChildContext(EventQuickCopy.quickCopy((EventContext)MessageProcessors.newChildContext(event, Optional.empty()), event), processor, false)))).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    public static Publisher<CoreEvent> process(CoreEvent event, ReactiveProcessor processor) {
        return Mono.just((Object)event).transform((Function)processor).onErrorMap(t -> !(t instanceof MessagingException), t -> {
            if (processor instanceof Component) {
                return new MessagingException(event, (Throwable)t, (Component)processor);
            }
            return new MessagingException(event, (Throwable)t);
        }).switchIfEmpty(Mono.from(((BaseEventContext)event.getContext()).getResponsePublisher())).doOnSuccess(MessageProcessors.completeSuccessIfNeeded(event.getContext(), true)).doOnError(MessageProcessors.completeErrorIfNeeded(event.getContext(), true));
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation) {
        BaseEventContext childContext = MessageProcessors.newChildContext(event, componentLocation);
        return MessageProcessors.internalProcessWithChildContextAlwaysComplete(event, EventQuickCopy.quickCopy((EventContext)childContext, event), processor, true);
    }

    public static Publisher<CoreEvent> processWithChildContextDontComplete(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation) {
        BaseEventContext childContext = MessageProcessors.newChildContext(event, componentLocation);
        return MessageProcessors.internalProcessWithChildContext(EventQuickCopy.quickCopy((EventContext)childContext, event), processor, true);
    }

    public static BaseEventContext newChildContext(CoreEvent event, Optional<ComponentLocation> componentLocation) {
        return DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation);
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, BaseEventContext childContext) {
        return MessageProcessors.internalProcessWithChildContext(EventQuickCopy.quickCopy((EventContext)childContext, event), processor, true);
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) {
        BaseEventContext childContext = DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation, exceptionHandler);
        return MessageProcessors.internalProcessWithChildContextAlwaysComplete(event, EventQuickCopy.quickCopy((EventContext)childContext, event), processor, true);
    }

    public static Publisher<CoreEvent> processWithChildContextDontComplete(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) {
        BaseEventContext childContext = DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation, exceptionHandler);
        return MessageProcessors.internalProcessWithChildContext(EventQuickCopy.quickCopy((EventContext)childContext, event), processor, true);
    }

    public static CoreEvent processWithChildContextBlocking(CoreEvent event, Processor processor, Optional<ComponentLocation> componentLocation) throws MuleException {
        return MessageProcessors.internalProcessWithChildContextBlocking(event, processor, DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation));
    }

    public static CoreEvent processWithChildContextBlocking(CoreEvent event, Processor processor, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) throws MuleException {
        return MessageProcessors.internalProcessWithChildContextBlocking(event, processor, DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation, exceptionHandler));
    }

    private static CoreEvent internalProcessWithChildContextBlocking(CoreEvent event, Processor processor, BaseEventContext child) throws MuleException {
        CoreEvent result;
        Publisher<CoreEvent> childResponsePublisher = child.getResponsePublisher();
        try {
            result = processor.process(EventQuickCopy.quickCopy((EventContext)child, event));
            MessageProcessors.completeSuccessIfNeeded().accept(result);
        }
        catch (MuleException e) {
            try {
                result = (CoreEvent)Mono.from(childResponsePublisher).block();
            }
            catch (Throwable t) {
                Throwable throwable = Exceptions.unwrap(t);
                if (throwable instanceof MessagingException) {
                    MessagingException error = (MessagingException)((Object)throwable);
                    throw Exceptions.rxExceptionToMuleException((Throwable)((Object)new MessagingException(MessageProcessors.toParentContext(error.getEvent()), error)));
                }
                if (t.getCause() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw Exceptions.rxExceptionToMuleException(t);
            }
        }
        return EventQuickCopy.quickCopy(event.getContext(), result);
    }

    private static Publisher<CoreEvent> internalProcessWithChildContext(CoreEvent eventChildCtx, ReactiveProcessor processor, boolean completeParentIfEmpty) {
        MonoSinkRecorder errorSwitchSinkSinkRef = new MonoSinkRecorder();
        return Mono.create(sink -> {
            MessageProcessors.childContextResponseHandler(eventChildCtx, new MonoSinkRecorderToReactorSinkAdapter<Either<MessagingException, CoreEvent>>(errorSwitchSinkSinkRef), completeParentIfEmpty);
            sink.success((Object)eventChildCtx);
        }).toProcessor().transform((Function)processor).doOnNext(MessageProcessors.completeSuccessIfNeeded()).switchIfEmpty((Mono)Mono.create(errorSwitchSinkSinkRef).map(MessageProcessors.childContextResponseMapper()).toProcessor()).map(MessageProcessors::toParentContext).subscriberContext(ctx -> ctx.put((Object)WITHIN_PROCESS_WITH_CHILD_CONTEXT, (Object)true));
    }

    private static Publisher<CoreEvent> internalProcessWithChildContextAlwaysComplete(CoreEvent event, CoreEvent eventChildCtx, ReactiveProcessor processor, boolean completeParentIfEmpty) {
        return Mono.from(MessageProcessors.internalProcessWithChildContext(eventChildCtx, processor, completeParentIfEmpty)).doOnSuccess(result -> {
            if (result == null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }).doOnError(e -> ((BaseEventContext)event.getContext()).error((Throwable)e)).onErrorMap(MessagingException.class, me -> new MessagingException(EventQuickCopy.quickCopy(eventChildCtx.getContext(), me.getEvent()), (MessagingException)((Object)me)));
    }

    private static Publisher<CoreEvent> internalApplyWithChildContext(Publisher<CoreEvent> eventChildCtxPub, ReactiveProcessor processor, boolean completeParentIfEmpty) {
        return Flux.from(eventChildCtxPub).compose(eventPub -> Mono.subscriberContext().flatMapMany(ctx -> {
            if (((Boolean)ctx.getOrDefault((Object)WITHIN_PROCESS_WITH_CHILD_CONTEXT, (Object)false)).booleanValue()) {
                return eventPub.flatMap(event -> MessageProcessors.internalProcessWithChildContext(event, processor, completeParentIfEmpty));
            }
            FluxSinkRecorder errorSwitchSinkSinkRef = new FluxSinkRecorder();
            Set seenContexts = Collections.newSetFromMap(new WeakHashMap());
            return Flux.from((Publisher)eventChildCtxPub).doOnNext(eventChildCtx -> MessageProcessors.childContextResponseHandler(eventChildCtx, new FluxSinkRecorderToReactorSinkAdapter<Either<MessagingException, CoreEvent>>(errorSwitchSinkSinkRef), completeParentIfEmpty)).transform((Function)processor).doOnNext(MessageProcessors.completeSuccessIfNeeded()).map(event -> Either.right(MessagingException.class, event)).doOnComplete(() -> errorSwitchSinkSinkRef.complete()).mergeWith((Publisher)Flux.create(errorSwitchSinkSinkRef)).map(MessageProcessors.childContextResponseMapper()).distinct(event -> (BaseEventContext)event.getContext(), () -> seenContexts).map(MessageProcessors::toParentContext);
        }));
    }

    private static void childContextResponseHandler(CoreEvent eventChildCtx, SinkRecorderToReactorSinkAdapter<Either<MessagingException, CoreEvent>> errorSwitchSinkSinkRef, boolean completeParentIfEmpty) {
        ((BaseEventContext)eventChildCtx.getContext()).onResponse((response, throwable) -> {
            try {
                if (throwable != null) {
                    MessagingException error = (MessagingException)((Object)((Object)throwable));
                    errorSwitchSinkSinkRef.next(Either.left(new MessagingException(MessageProcessors.toParentContext(error.getEvent()), error)));
                } else if (response == null && completeParentIfEmpty) {
                    MessageProcessors.getParentContext(eventChildCtx).success();
                    errorSwitchSinkSinkRef.next();
                } else if (response == null) {
                    errorSwitchSinkSinkRef.next();
                } else {
                    errorSwitchSinkSinkRef.next(Either.right(response));
                }
            }
            catch (Exception e) {
                LOGGER.error("Uncaught exception in childContextResponseHandler", (Throwable)e);
            }
        });
    }

    private static Function<? super Either<MessagingException, CoreEvent>, ? extends CoreEvent> childContextResponseMapper() {
        return result -> result.reduce(me -> {
            throw Exceptions.propagateWrappingFatal((Throwable)((Object)me));
        }, response -> response);
    }

    private static CoreEvent toParentContext(CoreEvent event) {
        return EventQuickCopy.quickCopy((EventContext)MessageProcessors.getParentContext(event), event);
    }

    private static BaseEventContext getParentContext(CoreEvent event) {
        return ((BaseEventContext)event.getContext()).getParentContext().orElse(null);
    }

    public static Publisher<CoreEvent> applyWithChildContext(Publisher<CoreEvent> eventPub, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation) {
        return MessageProcessors.internalApplyWithChildContext((Publisher<CoreEvent>)Flux.from(eventPub).map(event -> EventQuickCopy.quickCopy((EventContext)DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation), event)), processor, true);
    }

    public static Publisher<CoreEvent> applyWithChildContext(Publisher<CoreEvent> eventPub, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) {
        return MessageProcessors.internalApplyWithChildContext((Publisher<CoreEvent>)Flux.from(eventPub).map(event -> EventQuickCopy.quickCopy((EventContext)DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation, exceptionHandler), event)), processor, true);
    }

    public static Consumer<CoreEvent> completeSuccessIfNeeded(EventContext child, boolean complete) {
        return result -> {
            if (complete && !((BaseEventContext)child).isComplete()) {
                ((BaseEventContext)child).success((CoreEvent)result);
            }
        };
    }

    public static Consumer<Throwable> completeErrorIfNeeded(EventContext child, boolean complete) {
        return throwable -> {
            if (complete && !((BaseEventContext)child).isComplete()) {
                ((BaseEventContext)child).error((Throwable)throwable);
            }
        };
    }

    private static Consumer<CoreEvent> completeSuccessIfNeeded() {
        return result -> {
            BaseEventContext ctx = (BaseEventContext)result.getContext();
            if (!ctx.isComplete()) {
                ctx.success((CoreEvent)result);
            }
        };
    }

    public static Optional<ProcessingStrategy> getProcessingStrategy(ConfigurationComponentLocator locator, Location rootContainerLocation) {
        return locator.find(rootContainerLocation).filter(loc -> loc instanceof FlowConstruct).map(loc -> ((FlowConstruct)loc).getProcessingStrategy());
    }

    public static Publisher<CoreEvent> transform(Publisher<CoreEvent> publisher, ReactiveProcessor processor) {
        return Flux.from(publisher).transform((Function)processor);
    }

    public static Publisher<CoreEvent> map(Publisher<CoreEvent> publisher, Function<CoreEvent, CoreEvent> mapper) {
        return Flux.from(publisher).map(mapper);
    }

    public static Publisher<CoreEvent> flatMap(Publisher<CoreEvent> publisher, Function<CoreEvent, Publisher<CoreEvent>> function, Component component) {
        return Flux.from(publisher).flatMap(event -> Mono.from((Publisher)((Publisher)function.apply((CoreEvent)event))).onErrorMap(e -> !(e instanceof MessagingException), e -> new MessagingException((CoreEvent)event, (Throwable)e, component)));
    }

    public static Publisher<CoreEvent> justPublishOn(CoreEvent event, ExecutorService executor) {
        return Flux.just((Object)event).publishOn(Schedulers.fromExecutorService((ExecutorService)executor));
    }
}

