/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContext;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

public class MuleLoggerContextFactory {
    static final String LOG4J_CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";

    public LoggerContext build(ClassLoader classLoader, ArtifactAwareContextSelector selector) {
        NewContextParameters parameters = this.resolveContextParameters(classLoader);
        if (parameters == null) {
            return this.getDefaultContext(selector);
        }
        MuleLoggerContext loggerContext = new MuleLoggerContext(parameters.contextName, parameters.loggerConfigFile, classLoader, selector, this.isStandalone());
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)classLoader;
            artifactClassLoader.addShutdownListener(() -> selector.destroyLoggersFor(ArtifactAwareContextSelector.resolveLoggerContextClassLoader(classLoader)));
        }
        return loggerContext;
    }

    private NewContextParameters resolveContextParameters(ClassLoader classLoader) {
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)classLoader;
            return new NewContextParameters(this.getArtifactLoggingConfig(artifactClassLoader), artifactClassLoader.getArtifactId());
        }
        if (MuleContainerBootstrapUtils.getMuleConfDir() != null) {
            return new NewContextParameters(this.getLogConfig((LocalResourceLocator)new DirectoryResourceLocator(new String[]{MuleContainerBootstrapUtils.getMuleConfDir().getAbsolutePath()})), classLoader.toString());
        }
        return null;
    }

    private URI getArtifactLoggingConfig(ArtifactClassLoader muleCL) {
        URI appLogConfig;
        try {
            DeployableArtifactDescriptor appDescriptor = (DeployableArtifactDescriptor)muleCL.getArtifactDescriptor();
            if (appDescriptor.getLogConfigFile() == null) {
                appLogConfig = this.getLogConfig((LocalResourceLocator)muleCL);
            } else if (!appDescriptor.getLogConfigFile().exists()) {
                ArtifactAwareContextSelector.LOGGER.warn("Configured 'log.configFile' in app descriptor points to a non-existant file. Using default configuration.");
                appLogConfig = this.getLogConfig((LocalResourceLocator)muleCL);
            } else {
                appLogConfig = appDescriptor.getLogConfigFile().toURI();
            }
        }
        catch (Exception e) {
            ArtifactAwareContextSelector.LOGGER.warn("{} while looking for 'log.configFile' entry in app descriptor: {}. Using default configuration.", (Object)e.getClass().getName(), (Object)e.getMessage());
            appLogConfig = this.getLogConfig((LocalResourceLocator)muleCL);
        }
        if (appLogConfig != null && ArtifactAwareContextSelector.LOGGER.isInfoEnabled()) {
            ArtifactAwareContextSelector.LOGGER.info("Found logging config for application '{}' at '{}'", (Object)muleCL.getArtifactId(), (Object)appLogConfig);
        }
        return appLogConfig;
    }

    private LoggerContext getDefaultContext(ArtifactAwareContextSelector selector) {
        return new MuleLoggerContext("Default", selector, this.isStandalone());
    }

    private boolean isStandalone() {
        return MuleContainerBootstrapUtils.getMuleConfDir() != null;
    }

    private URI getLogConfig(LocalResourceLocator localResourceLocator) {
        URL localResource;
        URI appLogConfig = null;
        if (appLogConfig == null && (localResource = localResourceLocator.findLocalResource("log4j2-test.xml")) != null) {
            try {
                appLogConfig = localResource.toURI();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not read log file " + appLogConfig)), (Throwable)e);
            }
        }
        URI fallbackLogConfig = new File(MuleContainerBootstrapUtils.getMuleBase(), "conf/log4j2.xml").toURI();
        if (appLogConfig == null) {
            URL localResource2 = localResourceLocator.findLocalResource("log4j2.xml");
            try {
                if (localResource2 != null && !fallbackLogConfig.equals(localResource2.toURI())) {
                    appLogConfig = localResource2.toURI();
                }
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not read log file " + appLogConfig)), (Throwable)e);
            }
        }
        if (appLogConfig == null) {
            appLogConfig = System.getProperty(LOG4J_CONFIGURATION_FILE_PROPERTY) != null ? new File(System.getProperty(LOG4J_CONFIGURATION_FILE_PROPERTY)).toURI() : fallbackLogConfig;
        }
        return appLogConfig;
    }

    private class NewContextParameters {
        private final URI loggerConfigFile;
        private final String contextName;

        private NewContextParameters(URI loggerConfigFile, String contextName) {
            this.loggerConfigFile = loggerConfigFile;
            this.contextName = contextName;
        }
    }
}

