/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser.model.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.wsdl.parser.model.FaultModel;
import org.mule.wsdl.parser.model.NamedModel;
import org.mule.wsdl.parser.model.WsdlStyle;
import org.mule.wsdl.parser.model.WsdlStyleFinder;
import org.mule.wsdl.parser.model.operation.OperationType;
import org.mule.wsdl.parser.model.operation.SoapHeader;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\nJ\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0#J\u0006\u0010(\u001a\u00020\u001bJ\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030#J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\nJ\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0#J\u0006\u0010,\u001a\u00020\u001bJ\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030#J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010/\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lorg/mule/wsdl/parser/model/operation/OperationModel;", "Lorg/mule/wsdl/parser/model/NamedModel;", "name", "", "bop", "Ljavax/wsdl/BindingOperation;", "(Ljava/lang/String;Ljavax/wsdl/BindingOperation;)V", "getName", "()Ljava/lang/String;", "soapAction", "Ljava/util/Optional;", "getSoapAction", "()Ljava/util/Optional;", "style", "Lorg/mule/wsdl/parser/model/WsdlStyle;", "getStyle", "()Lorg/mule/wsdl/parser/model/WsdlStyle;", "type", "Lorg/mule/wsdl/parser/model/operation/OperationType;", "getType", "()Lorg/mule/wsdl/parser/model/operation/OperationType;", "findAction", "findStyle", "findType", "getBodyPart", "Ljavax/wsdl/Part;", "message", "Ljavax/wsdl/Message;", "bindingType", "Ljavax/wsdl/extensions/ElementExtensible;", "getBodyPartName", "getFault", "Lorg/mule/wsdl/parser/model/FaultModel;", "faultName", "getFaults", "", "getHeaderParts", "Lorg/mule/wsdl/parser/model/operation/SoapHeader;", "getInputBodyPart", "getInputHeaders", "getInputMessage", "getInputParts", "getOutputBodyPart", "getOutputHeaders", "getOutputMessage", "getOutputParts", "getPartNames", "elementExtensible", "mule-wsdl-parser"})
public final class OperationModel
implements NamedModel {
    @Nullable
    private final WsdlStyle style;
    @NotNull
    private final OperationType type;
    @NotNull
    private final Optional<String> soapAction;
    @NotNull
    private final String name;
    private final BindingOperation bop;

    @Nullable
    public final WsdlStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final OperationType getType() {
        return this.type;
    }

    @NotNull
    public final Optional<String> getSoapAction() {
        return this.soapAction;
    }

    @NotNull
    public final Message getInputMessage() {
        Message message = this.bop.getOperation().getInput().getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"bop.operation.input.message");
        return message;
    }

    @NotNull
    public final Message getOutputMessage() {
        Message message = this.bop.getOperation().getOutput().getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"bop.operation.output.message");
        return message;
    }

    @NotNull
    public final Optional<Part> getInputBodyPart() {
        Message message = this.getInputMessage();
        BindingInput bindingInput = this.bop.getBindingInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingInput, (String)"bop.bindingInput");
        return this.getBodyPart(message, (ElementExtensible)bindingInput);
    }

    @NotNull
    public final List<String> getInputParts() {
        BindingInput bindingInput = this.bop.getBindingInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingInput, (String)"bop.bindingInput");
        return this.getPartNames((ElementExtensible)bindingInput);
    }

    @NotNull
    public final List<String> getOutputParts() {
        BindingOutput bindingOutput = this.bop.getBindingOutput();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingOutput, (String)"bop.bindingOutput");
        return this.getPartNames((ElementExtensible)bindingOutput);
    }

    @NotNull
    public final Optional<Part> getOutputBodyPart() {
        Message message = this.getOutputMessage();
        BindingOutput bindingOutput = this.bop.getBindingOutput();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingOutput, (String)"bop.bindingOutput");
        return this.getBodyPart(message, (ElementExtensible)bindingOutput);
    }

    @NotNull
    public final List<SoapHeader> getInputHeaders() {
        BindingInput bindingInput = this.bop.getBindingInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingInput, (String)"bop.bindingInput");
        return this.getHeaderParts((ElementExtensible)bindingInput);
    }

    @NotNull
    public final List<SoapHeader> getOutputHeaders() {
        BindingOutput bindingOutput = this.bop.getBindingOutput();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingOutput, (String)"bop.bindingOutput");
        return this.getHeaderParts((ElementExtensible)bindingOutput);
    }

    @NotNull
    public final FaultModel getFault(@NotNull String faultName) {
        Intrinsics.checkParameterIsNotNull((Object)faultName, (String)"faultName");
        try {
            Fault fault = this.bop.getOperation().getFault(faultName);
            Intrinsics.checkExpressionValueIsNotNull((Object)fault, (String)"bop.operation.getFault(faultName)");
            return new FaultModel(fault);
        }
        catch (Exception e) {
            throw (Throwable)new IllegalArgumentException("Could not retrieve fault [" + this.getName() + "]", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FaultModel> getFaults() {
        void var3_3;
        void $receiver$iv$iv;
        Map $receiver$iv;
        Map map = $receiver$iv = this.bop.getOperation().getFaults();
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var4_4 = $receiver$iv$iv;
        Iterator iterator = var4_4.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            void $$_$_v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            void var8_8 = $$_$_v;
            Object v2 = v = var8_8.getValue();
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.Fault");
            }
            FaultModel faultModel = new FaultModel((Fault)v2);
            collection.add(faultModel);
        }
        return (List)var3_3;
    }

    private final OperationType findType() {
        javax.wsdl.OperationType operationType = this.bop.getOperation().getStyle();
        return Intrinsics.areEqual((Object)operationType, (Object)javax.wsdl.OperationType.NOTIFICATION) ? OperationType.NOTIFICATION : (Intrinsics.areEqual((Object)operationType, (Object)javax.wsdl.OperationType.SOLICIT_RESPONSE) ? OperationType.SOLICIT_RESPONSE : (Intrinsics.areEqual((Object)operationType, (Object)javax.wsdl.OperationType.ONE_WAY) ? OperationType.ONE_WAY : OperationType.REQUEST_RESPONSE));
    }

    private final WsdlStyle findStyle() {
        Object e;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.bop.getExtensibilityElements();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            e = element$iv$iv;
            if (!(e instanceof SOAP12Operation || e instanceof SOAPOperation)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object item$iv$iv;
            e = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            if (e instanceof SOAPOperation) {
                string = ((SOAPOperation)e).getStyle();
            } else {
                Object t = e;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.extensions.soap12.SOAP12Operation");
                }
                string = ((SOAP12Operation)t).getStyle();
            }
            String string2 = string;
            collection.add(string2);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(it != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String style = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return style != null ? WsdlStyleFinder.INSTANCE.find(style) : null;
    }

    private final Optional<String> findAction() {
        Optional<String> optional;
        Object e;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.bop.getExtensibilityElements();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            e = element$iv$iv;
            if (!(e instanceof SOAP12Operation || e instanceof SOAPOperation)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object item$iv$iv;
            e = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            if (e instanceof SOAPOperation) {
                string = ((SOAPOperation)e).getSoapActionURI();
            } else {
                Object t = e;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.extensions.soap12.SOAP12Operation");
                }
                string = ((SOAP12Operation)t).getSoapActionURI();
            }
            String string2 = string;
            collection.add(string2);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(it != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String action = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (StringUtils.isBlank((CharSequence)action)) {
            Optional optional2 = Optional.empty();
            optional = optional2;
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.empty()");
        } else {
            Optional<String> optional3 = Optional.ofNullable(action);
            optional = optional3;
            Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"ofNullable(action)");
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private final Optional<Part> getBodyPart(Message message, ElementExtensible bindingType) {
        Map parts = message.getParts();
        if (parts == null || parts.isEmpty()) {
            Optional<Part> optional = Optional.empty();
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
            return optional;
        }
        if (parts.size() == 1) {
            void $receiver$iv;
            Collection collection = parts.keySet();
            Map map = parts;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v1;
            Object[] objectArray = thisCollection$iv.toArray(new Object[thisCollection$iv.size()]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray2 = objectArray;
            Object v = map.get(objectArray2[0]);
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.Part");
            }
            Optional<Part> optional = Optional.ofNullable((Part)v);
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"ofNullable(parts[parts.k\u2026TypedArray()[0]] as Part)");
            return optional;
        }
        Optional<Part> optional = this.getBodyPartName(bindingType).flatMap(new Function<T, Optional<U>>(parts){
            final /* synthetic */ Map $parts;

            @NotNull
            public final Optional<Part> apply(String partName) {
                V v = this.$parts.get(partName);
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.Part");
                }
                return Optional.ofNullable((Part)v);
            }
            {
                this.$parts = map;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"getBodyPartName(bindingT\u2026arts[partName] as Part) }");
        return optional;
    }

    private final Optional<String> getBodyPartName(ElementExtensible bindingType) {
        List<String> bodyParts;
        List elements = bindingType.getExtensibilityElements();
        if (elements != null && !(bodyParts = this.getPartNames(bindingType)).isEmpty()) {
            Optional<String> optional = Optional.ofNullable(bodyParts.get(0));
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"ofNullable(bodyParts[0])");
            return optional;
        }
        Optional<String> optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPartNames(ElementExtensible elementExtensible) {
        void $receiver$iv$iv;
        List<String> list;
        Collection collection;
        Object e;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        List elements = elementExtensible.getExtensibilityElements();
        Iterable iterable = elements;
        void var5_4 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            e = element$iv$iv;
            if (!(e instanceof SOAPBody || e instanceof SOAP12Body)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            List<String> list2;
            Object item$iv$iv;
            e = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            if (e instanceof SOAPBody) {
                list2 = ((SOAPBody)e).getParts();
            } else {
                Object t = e;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.extensions.soap12.SOAP12Body");
                }
                list2 = ((SOAP12Body)t).getParts();
            }
            list = list2;
            collection.add(list);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            List parts = (List)element$iv$iv;
            List list3 = parts;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List partNames = (List)destination$iv$iv;
        if (!partNames.isEmpty()) {
            return partNames;
        }
        Iterable $receiver$iv2 = elements;
        destination$iv$iv = $receiver$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object e2 = element$iv$iv;
            if (!(e2 instanceof MIMEMultipartRelated)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List multiparts = (List)destination$iv$iv2;
        if (!multiparts.isEmpty()) {
            void $receiver$iv$iv3;
            Object e3 = multiparts.get(0);
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.extensions.mime.MIMEMultipartRelated");
            }
            MIMEMultipartRelated multipart = (MIMEMultipartRelated)e3;
            Iterable $receiver$iv3 = multipart.getMIMEParts();
            destination$iv$iv2 = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            Iterator iterator2 = $receiver$iv$iv3.iterator();
            while (iterator2.hasNext()) {
                void e4;
                Object item$iv$iv;
                Object $i$a$1$filter = item$iv$iv = iterator2.next();
                collection = destination$iv$iv3;
                void v4 = e4;
                if (v4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.extensions.ElementExtensible");
                }
                list = this.getPartNames((ElementExtensible)v4);
                collection.add(list);
            }
            return CollectionsKt.flatten((Iterable)((List)destination$iv$iv3));
        }
        return CollectionsKt.emptyList();
    }

    private final List<SoapHeader> getHeaderParts(ElementExtensible bindingType) {
        List extensible = bindingType.getExtensibilityElements();
        if (extensible != null) {
            Object e;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = extensible;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                e = element$iv$iv;
                if (!(e instanceof SOAPHeader || e instanceof SOAP12Header)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                SoapHeader soapHeader;
                Object item$iv$iv;
                e = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                if (e instanceof SOAPHeader) {
                    soapHeader = new SoapHeader((SOAPHeader)e);
                } else {
                    Object t = e;
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.extensions.soap12.SOAP12Header");
                    }
                    soapHeader = new SoapHeader((SOAP12Header)t);
                }
                SoapHeader soapHeader2 = soapHeader;
                collection.add(soapHeader2);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public OperationModel(@NotNull String name, @NotNull BindingOperation bop) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)bop, (String)"bop");
        this.name = name;
        this.bop = bop;
        this.style = this.findStyle();
        this.type = this.findType();
        this.soapAction = this.findAction();
    }
}

