/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureFlaggingService;
import org.mule.runtime.core.internal.config.DefaultFeatureFlaggingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeatureFlaggingServiceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFlaggingServiceBuilder.class);
    private MuleContext context;
    private Map<Feature, Predicate<MuleContext>> configurations;

    public FeatureFlaggingServiceBuilder context(MuleContext context) {
        this.context = context;
        return this;
    }

    public FeatureFlaggingServiceBuilder configurations(Map<Feature, Predicate<MuleContext>> cofigurations) {
        this.configurations = cofigurations;
        return this;
    }

    public FeatureFlaggingService build() {
        HashMap<Feature, Boolean> features = new HashMap<Feature, Boolean>();
        LOGGER.debug("Configuring feature flags...");
        String id = this.context.getConfiguration().getId();
        this.configurations.forEach((feature, p) -> {
            boolean enabled;
            Optional systemPropertyName = feature.getOverridingSystemPropertyName();
            if (systemPropertyName.isPresent() && System.getProperty((String)systemPropertyName.get()) != null) {
                enabled = Boolean.getBoolean((String)systemPropertyName.get());
                LOGGER.debug("Setting feature {} = {} for artifact [{}] because of System Property '{}'", new Object[]{feature, enabled, id, systemPropertyName});
            } else {
                enabled = p.test(this.context);
                LOGGER.debug("Setting feature {} = {} for artifact [{}]", new Object[]{feature, enabled, id});
            }
            features.put((Feature)feature, enabled);
        });
        return new DefaultFeatureFlaggingService(features);
    }
}

