/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.internal.construct.FlowBackPressureEventsAccumulatedException;
import org.mule.runtime.core.internal.construct.FlowBackPressureMaxConcurrencyExceededException;
import org.mule.runtime.core.internal.construct.FlowBackPressureRequiredSchedulerBusyException;
import org.mule.runtime.core.internal.construct.FlowBackPressureRequiredSchedulerBusyWithFullBufferException;

public abstract class FlowBackPressureException
extends MuleException {
    static final String BACK_PRESSURE_ERROR_MESSAGE = "Flow '%s' is unable to accept new events at this time. Reason: %s";
    private static final long serialVersionUID = -4973370165925845336L;
    private final Component flow;

    public FlowBackPressureException(Component flow, BackPressureReason reason) {
        super(CoreMessages.backpressure(flow.getLocation().getRootContainerName(), reason));
        this.flow = flow;
    }

    public FlowBackPressureException(Component flow, BackPressureReason reason, Throwable cause) {
        super(CoreMessages.backpressure(flow.getLocation().getRootContainerName(), reason), cause);
        this.flow = flow;
    }

    public static FlowBackPressureException createFlowBackPressureException(Component flow, BackPressureReason reason, Throwable cause) {
        switch (reason) {
            case MAX_CONCURRENCY_EXCEEDED: {
                return new FlowBackPressureMaxConcurrencyExceededException(flow, reason, cause);
            }
            case REQUIRED_SCHEDULER_BUSY: {
                return new FlowBackPressureRequiredSchedulerBusyException(flow, reason, cause);
            }
            case REQUIRED_SCHEDULER_BUSY_WITH_FULL_BUFFER: {
                return new FlowBackPressureRequiredSchedulerBusyWithFullBufferException(flow, reason, cause);
            }
            case EVENTS_ACCUMULATED: {
                return new FlowBackPressureEventsAccumulatedException(flow, reason, cause);
            }
        }
        throw new IllegalArgumentException("Cannot build a FlowBackPressureException with a cause without a reason");
    }

    public static void createAndThrowIfNeeded(Component flow, BackPressureReason reason, Throwable cause) throws FlowBackPressureException {
        FlowBackPressureException toThrow = FlowBackPressureException.createFlowBackPressureException(flow, reason, cause);
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public Component getFlow() {
        return this.flow;
    }
}

