/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.PolicyEventMapper;
import org.mule.runtime.core.internal.policy.PolicyTraceLogger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class OperationPolicyProcessor
implements ReactiveProcessor {
    private final Policy policy;
    private final Reference<ReactiveProcessor> nextProcessorRef;
    private final PolicyEventMapper policyEventMapper;
    private final PolicyTraceLogger policyTraceLogger;

    public OperationPolicyProcessor(Policy policy, ReactiveProcessor nextProcessor) {
        this.policy = policy;
        this.nextProcessorRef = new WeakReference<ReactiveProcessor>(nextProcessor);
        this.policyEventMapper = new PolicyEventMapper(policy.getPolicyId());
        this.policyTraceLogger = new PolicyTraceLogger();
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).map(this.policyEventMapper::onOperationPolicyBegin).doOnNext(event -> this.policyTraceLogger.logOperationPolicyStart(this.policy, (CoreEvent)event)).transform((Function)this.policy.getPolicyChain().onChainError(t -> this.manageError((MessagingException)((Object)((Object)t))))).subscriberContext(ctx -> ctx.put((Object)"policy.nextOperation", this.nextProcessorRef)).doOnNext(event -> this.policyTraceLogger.logOperationPolicyEnd(this.policy, (CoreEvent)event)).map(policyChainResult -> this.policyEventMapper.onOperationPolicyFinish((CoreEvent)policyChainResult, this.policy.getPolicyChain().isPropagateMessageTransformations()));
    }

    private void manageError(MessagingException messagingException) {
        messagingException.setProcessedEvent(this.policyEventMapper.onOperationPolicyError(messagingException.getEvent()));
    }
}

