/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.SourceInterceptor;
import org.mule.runtime.api.interception.SourceInterceptorFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.SourcePolicyResult;
import org.mule.runtime.core.internal.processor.interceptor.AbstractInterceptorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;

public abstract class AbstractCompletableInterceptorSourceCallbackAdapter<T extends SourcePolicyResult>
extends AbstractInterceptorAdapter
implements BiFunction<MessageSource, BiConsumer<T, CompletableCallback<Void>>, BiConsumer<T, CompletableCallback<Void>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompletableInterceptorSourceCallbackAdapter.class);
    private SourceInterceptorFactory interceptorFactory;

    public AbstractCompletableInterceptorSourceCallbackAdapter(SourceInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public BiConsumer<T, CompletableCallback<Void>> apply(MessageSource source, BiConsumer<T, CompletableCallback<Void>> next) {
        if (!this.isInterceptable(source)) {
            return next;
        }
        ComponentLocation componentLocation = source.getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        SourceInterceptor interceptor = (SourceInterceptor)this.interceptorFactory.get();
        Map dslParameters = (Map)source.getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        return (result, callback) -> {
            SourcePolicyResult interceptedBeforeResult = this.applyBefore(this.doBefore(interceptor, source, dslParameters).apply((InternalEvent)result.getResult()), result);
            try {
                next.accept((T)interceptedBeforeResult, (CompletableCallback<Void>)callback);
                this.doAfter(interceptor, source, Optional.empty()).apply((InternalEvent)interceptedBeforeResult.getResult());
            }
            catch (Throwable t) {
                this.doAfter(interceptor, source, Optional.of(t)).apply((InternalEvent)interceptedBeforeResult.getResult());
                callback.error(t);
            }
        };
    }

    protected abstract T applyBefore(InternalEvent var1, T var2);

    protected Function<InternalEvent, InternalEvent> doBefore(SourceInterceptor interceptor, Component component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            LOGGER.debug("Calling before() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            try {
                Thread currentThread = Thread.currentThread();
                ClassLoader originalTCCL = currentThread.getContextClassLoader();
                ClassLoader ctxClassLoader = interceptor.getClass().getClassLoader();
                ClassUtils.setContextClassLoader(currentThread, originalTCCL, ctxClassLoader);
                try {
                    interceptor.beforeCallback(component.getLocation(), this.getResolvedParams(eventWithResolvedParams), (InterceptionEvent)interceptionEvent);
                }
                finally {
                    ClassUtils.setContextClassLoader(currentThread, ctxClassLoader, originalTCCL);
                }
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)((Object)new MessagingException((CoreEvent)interceptionEvent.resolve(), e.getCause(), component)));
            }
        };
    }

    protected Function<InternalEvent, InternalEvent> doAfter(SourceInterceptor interceptor, Component component, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            LOGGER.debug("Calling after() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            try {
                Thread currentThread = Thread.currentThread();
                ClassLoader originalTCCL = currentThread.getContextClassLoader();
                ClassLoader ctxClassLoader = interceptor.getClass().getClassLoader();
                ClassUtils.setContextClassLoader(currentThread, originalTCCL, ctxClassLoader);
                try {
                    interceptor.afterCallback(component.getLocation(), (InterceptionEvent)interceptionEvent, thrown);
                }
                finally {
                    ClassUtils.setContextClassLoader(currentThread, ctxClassLoader, originalTCCL);
                }
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)((Object)this.createMessagingException(interceptionEvent.resolve(), e.getCause(), component, Optional.empty())));
            }
        };
    }

    private boolean isInterceptable(Component component) {
        return component.getLocation() != null;
    }
}

