/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptionAction;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class ReactiveAroundInterceptorAdapter
extends ReactiveInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveAroundInterceptorAdapter.class);
    private static final String AROUND_METHOD_NAME = "around";

    public ReactiveAroundInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        super(interceptorFactory);
    }

    @Override
    protected ReactiveProcessor doApply(Processor component, ReactiveProcessor next, ComponentLocation componentLocation, ProcessorInterceptor interceptor, Map<String, String> dslParameters) {
        if (this.implementsAround(interceptor)) {
            LOGGER.debug("Configuring interceptor '{}' around processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            return publisher -> Mono.subscriberContext().flatMapMany(ctx -> Flux.from((Publisher)publisher).cast(InternalEvent.class).flatMap(event -> Mono.fromFuture(this.doAround((InternalEvent)event, interceptor, component, dslParameters, next, (Context)ctx)).onErrorMap(CompletionException.class, completionException -> completionException.getCause())));
        }
        return next;
    }

    private boolean implementsAround(ProcessorInterceptor interceptor) {
        try {
            return !interceptor.getClass().getMethod(AROUND_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class, InterceptionAction.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<InternalEvent> doAround(InternalEvent event, ProcessorInterceptor interceptor, Processor component, Map<String, String> dslParameters, ReactiveProcessor next, Context ctx) {
        InternalEvent eventWithResolvedParams = this.addResolvedParameters(event, (Component)component, dslParameters);
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
        ReactiveInterceptionAction reactiveInterceptionAction = new ReactiveInterceptionAction(interceptionEvent, next, ctx, component, this.errorTypeLocator);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling around() for '{}' in processor '{}'...", (Object)interceptor, (Object)((Component)component).getLocation().getLocation());
        }
        try {
            CompletableFuture interception;
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            ClassLoader contextClassLoader = interceptor.getClass().getClassLoader();
            ClassUtils.setContextClassLoader(currentThread, currentClassLoader, contextClassLoader);
            try {
                interception = interceptor.around(((Component)component).getLocation(), this.getResolvedParams(eventWithResolvedParams), (InterceptionEvent)interceptionEvent, (InterceptionAction)reactiveInterceptionAction);
            }
            finally {
                ClassUtils.setContextClassLoader(currentThread, contextClassLoader, currentClassLoader);
            }
            return ((CompletableFuture)interception.exceptionally(t -> {
                if (t instanceof MessagingException) {
                    throw new CompletionException((Throwable)t);
                }
                throw new CompletionException((Throwable)((Object)this.createMessagingException(eventWithResolvedParams, t instanceof CompletionException ? t.getCause() : t, (Component)component, Optional.empty())));
            })).thenApply(interceptedEvent -> interceptedEvent != null ? ((DefaultInterceptionEvent)interceptedEvent).resolve() : null);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)((Object)this.createMessagingException(interceptionEvent.resolve(), e, (Component)component, Optional.empty())));
        }
    }
}

