/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.routing.ExecutableRoute;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.routing.RoutingException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

abstract class AbstractSinkRouter {
    private final Flux<CoreEvent> router;
    private final List<ExecutableRoute> routes;
    private final ExecutableRoute phantomRoute;

    protected AbstractSinkRouter(Publisher<CoreEvent> publisher, List<ProcessorRoute> routes) {
        this.routes = routes.stream().map(ProcessorRoute::toExecutableRoute).collect(Collectors.toList());
        this.phantomRoute = new ExecutableRoute(new ProcessorRoute(e -> e));
        this.router = Flux.from(publisher).doOnNext(Exceptions.checkedConsumer(this::route)).doOnComplete(() -> {
            this.routes.stream().forEach(ExecutableRoute::complete);
            this.phantomRoute.complete();
        });
    }

    List<Flux<CoreEvent>> collectPublishers() {
        ArrayList<Flux<CoreEvent>> routePublishers = new ArrayList<Flux<CoreEvent>>();
        for (ExecutableRoute nextRoute : this.routes) {
            routePublishers.add(nextRoute.getPublisher());
        }
        routePublishers.add(RxUtils.subscribeFluxOnPublisherSubscription(this.phantomRoute.getPublisher(), this.router));
        return routePublishers;
    }

    protected abstract void route(CoreEvent var1) throws RoutingException;

    protected List<ExecutableRoute> getRoutes() {
        return this.routes;
    }
}

