/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.internal.util.queue.CacheAwareQueueStore;
import org.mule.runtime.core.internal.util.queue.QueueProvider;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.QueueStoreCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueueManager
implements QueueManager,
QueueProvider,
QueueStoreCacheListener,
MuleContextAware,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQueueManager.class);
    private final Map<String, CacheAwareQueueStore> queues = new ConcurrentHashMap<String, CacheAwareQueueStore>();
    private final Map<String, QueueConfiguration> queueConfigurations = new HashMap<String, QueueConfiguration>();
    private QueueConfiguration defaultQueueConfiguration = new DefaultQueueConfiguration();
    private MuleContext muleContext;

    @Override
    public synchronized void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.defaultQueueConfiguration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueueConfiguration(String queueName, QueueConfiguration newConfig) {
        Map<String, QueueConfiguration> map = this.queueConfigurations;
        synchronized (map) {
            if (this.queues.containsKey(queueName) && !newConfig.equals(this.queueConfigurations.get(queueName))) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("A queue with name %s is in use so we cannot change it's configuration", queueName)));
            }
            if (LOGGER.isDebugEnabled() && this.queueConfigurations.containsKey(queueName)) {
                QueueConfiguration oldConfiguration = this.queueConfigurations.get(queueName);
                LOGGER.debug(String.format("Replacing queue %s configuration: %s with new newConfig: %s", queueName, oldConfiguration, newConfig));
            }
            this.queueConfigurations.put(queueName, newConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<QueueConfiguration> getQueueConfiguration(String queueName) {
        Map<String, QueueConfiguration> map = this.queueConfigurations;
        synchronized (map) {
            return Optional.ofNullable(this.queueConfigurations.get(queueName));
        }
    }

    private QueueStore getQueue(String name, QueueConfiguration config) {
        CacheAwareQueueStore queueStore = this.queues.get(name);
        if (queueStore != null) {
            return queueStore;
        }
        return this.queues.computeIfAbsent(name, n -> new CacheAwareQueueStore(this.createQueueStore((String)n, config), this));
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    public final void dispose() {
        this.doDispose();
        this.queues.clear();
    }

    @Override
    public void disposeQueueStore(QueueStore queueStore) {
        this.removeQueueFromCache(queueStore);
    }

    @Override
    public void closeQueueStore(QueueStore queueStore) {
        this.removeQueueFromCache(queueStore);
    }

    private void removeQueueFromCache(QueueStore queueStore) {
        try {
            if (queueStore == null) {
                throw new IllegalArgumentException("Queue to be disposed cannot be null");
            }
            String queueName = queueStore.getName();
            if (this.queues.remove(queueName) == null) {
                throw new IllegalArgumentException(String.format("There's no queue for name %s", queueName));
            }
            this.clearQueueConfiguration(queueName);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public synchronized QueueStore getQueue(String queueName) {
        return this.getQueue(queueName, this.defineQueueConfiguration(queueName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueConfiguration defineQueueConfiguration(String queueName) {
        Map<String, QueueConfiguration> map = this.queueConfigurations;
        synchronized (map) {
            if (!this.queueConfigurations.containsKey(queueName)) {
                this.setQueueConfiguration(queueName, this.defaultQueueConfiguration);
                return this.defaultQueueConfiguration;
            }
            return this.queueConfigurations.get(queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearQueueConfiguration(String queueName) {
        Map<String, QueueConfiguration> map = this.queueConfigurations;
        synchronized (map) {
            this.queueConfigurations.remove(queueName);
        }
    }

    protected abstract QueueStore createQueueStore(String var1, QueueConfiguration var2);

    protected abstract void doDispose();
}

