/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.exception.WildcardErrorTypeMatcher;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.ErrorHandlerContextManager;
import org.mule.runtime.core.internal.exception.ExceptionRouter;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

@NoExtend
public abstract class TemplateOnErrorHandler
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateOnErrorHandler.class);
    private static final Pattern ERROR_HANDLER_LOCATION_PATTERN = Pattern.compile(".*/.*/.*");
    @Inject
    protected ConfigurationComponentLocator locator;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ConfigurationProperties configurationProperties;
    protected Optional<Location> flowLocation = Optional.empty();
    private MessageProcessorChain configuredMessageProcessors;
    protected Optional<String> when = Optional.empty();
    protected boolean handleException;
    protected String errorType = null;
    protected ErrorTypeMatcher errorTypeMatcher = null;
    private String errorHandlerLocation;
    private boolean isLocalErrorHandlerLocation;
    private ComponentLocation location;
    private Function<Function<Publisher<CoreEvent>, Publisher<CoreEvent>>, FluxSink<CoreEvent>> fluxFactory;

    @Override
    public final CoreEvent handleException(Exception exception, CoreEvent event) {
        try {
            return (CoreEvent)this.applyInternal(exception).block();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(Exceptions.unwrap(throwable));
        }
    }

    @Override
    public Consumer<Exception> router(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor, final Consumer<CoreEvent> continueCallback, final Consumer<Throwable> propagateCallback) {
        final FluxSink<CoreEvent> fluxSink = this.fluxFactory.apply(publisherPostProcessor);
        return new ExceptionRouter(){

            public void dispose() {
                fluxSink.complete();
            }

            @Override
            public void accept(Exception error) {
                fluxSink.next((Object)ErrorHandlerContextManager.addContext(TemplateOnErrorHandler.this, (MessagingException)((Object)error), continueCallback, propagateCallback));
            }
        };
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        return this.applyInternal(exception);
    }

    private Mono<CoreEvent> applyInternal(Exception exception) {
        return Mono.create(sink -> {
            Consumer<Exception> router = this.router(Function.identity(), handledEvent -> sink.success(handledEvent), rethrownError -> sink.error(rethrownError));
            try {
                router.accept(exception);
            }
            finally {
                LifecycleUtils.disposeIfNeeded(router, LOGGER);
            }
        });
    }

    private BiConsumer<Throwable, Object> onRoutingError() {
        return (me, event) -> {
            try {
                this.logger.error("Exception during exception strategy execution");
                this.resolveAndLogException((Throwable)me);
                if (this.isOwnedTransaction()) {
                    TransactionCoordination.getInstance().rollbackCurrentTransaction();
                }
            }
            catch (Exception ex) {
                this.logger.warn(ex.getMessage());
            }
            CoreEvent result = this.afterRouting().apply(((MessagingException)((Object)((Object)me))).getEvent());
            this.fireEndNotification(ErrorHandlerContextManager.from(this, ((MessagingException)((Object)((Object)me))).getEvent()).getOriginalEvent(), result, (Throwable)me);
            ErrorHandlerContextManager.resolveHandling((FlowExceptionHandler)this, (MessagingException)((Object)((Object)me)));
        };
    }

    private void fireEndNotification(CoreEvent event, CoreEvent result, Throwable throwable) {
        this.notificationFirer.dispatch((Notification)new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo((Event)(result != null ? result : event), (Exception)((Object)(throwable instanceof MessagingException ? (MessagingException)((Object)throwable) : null)), (Component)this.configuredMessageProcessors), this.location, 2002));
    }

    protected Publisher<CoreEvent> route(Publisher<CoreEvent> eventPublisher) {
        return Flux.from(eventPublisher).transform((Function)this.configuredMessageProcessors);
    }

    @Override
    public void setMessageProcessors(List<Processor> processors) {
        super.setMessageProcessors(processors);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.configuredMessageProcessors == null ? new ArrayList() : Collections.singletonList(this.configuredMessageProcessors);
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)((Object)exception)).setHandled(true);
        }
    }

    protected CoreEvent nullifyExceptionPayloadIfRequired(CoreEvent event) {
        if (this.handleException) {
            return CoreEvent.builder(event).error(null).build();
        }
        return event;
    }

    private void processStatistics() {
        if (this.statistics != null && this.statistics.isEnabled()) {
            this.statistics.incExecutionError();
        }
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.location = this.getLocation();
        Optional<ProcessingStrategy> processingStrategy = Optional.empty();
        if (this.flowLocation.isPresent()) {
            processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, this.flowLocation.get());
        } else if (this.location != null) {
            processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation());
        }
        this.configuredMessageProcessors = MessageProcessors.buildNewChainWithListOfProcessors(processingStrategy, this.getMessageProcessors(), NullExceptionHandler.getInstance());
        this.fluxFactory = new OnErrorHandlerFluxObjectFactory(processingStrategy);
        this.errorTypeMatcher = TemplateOnErrorHandler.createErrorType(this.errorTypeRepository, this.errorType, this.configurationProperties);
        if (!this.inDefaultErrorHandler()) {
            this.errorHandlerLocation = this.location.getLocation();
            this.isLocalErrorHandlerLocation = ERROR_HANDLER_LOCATION_PATTERN.matcher(this.errorHandlerLocation).find();
            if (this.isLocalErrorHandlerLocation) {
                this.errorHandlerLocation = this.errorHandlerLocation.substring(0, this.errorHandlerLocation.lastIndexOf(47));
                this.errorHandlerLocation = this.errorHandlerLocation.substring(0, this.errorHandlerLocation.lastIndexOf(47));
            }
        }
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.fluxFactory, LOGGER);
        super.dispose();
    }

    public static ErrorTypeMatcher createErrorType(ErrorTypeRepository errorTypeRepository, String errorTypeNames, ConfigurationProperties configurationProperties) {
        if (errorTypeNames == null) {
            return null;
        }
        String[] errorTypeIdentifiers = errorTypeNames.split(",");
        List<ErrorTypeMatcher> matchers = Arrays.stream(errorTypeIdentifiers).map(identifier -> {
            String parsedIdentifier = identifier.trim();
            ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)parsedIdentifier);
            if (TemplateOnErrorHandler.doesErrorTypeContainWildcards(errorTypeComponentIdentifier)) {
                return new WildcardErrorTypeMatcher(errorTypeComponentIdentifier);
            }
            return new SingleErrorTypeMatcher(errorTypeRepository.lookupErrorType(errorTypeComponentIdentifier).orElseGet(() -> {
                if (configurationProperties.resolveBooleanProperty("mule.application.deployment.lazyInit").orElse(false).booleanValue()) {
                    return errorTypeRepository.addErrorType(errorTypeComponentIdentifier, errorTypeRepository.getAnyErrorType());
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find ErrorType for the given identifier: '%s'", (Object[])new Object[]{parsedIdentifier}));
            }));
        }).collect(Collectors.toList());
        return new DisjunctiveErrorTypeMatcher(matchers);
    }

    private static boolean doesErrorTypeContainWildcards(ComponentIdentifier errorTypeIdentifier) {
        if (errorTypeIdentifier == null) {
            return false;
        }
        if (Objects.equals(WildcardErrorTypeMatcher.WILDCARD_TOKEN, errorTypeIdentifier.getName())) {
            return true;
        }
        return Objects.equals(WildcardErrorTypeMatcher.WILDCARD_TOKEN, errorTypeIdentifier.getNamespace());
    }

    @Deprecated
    public static ErrorTypeMatcher createErrorType(ErrorTypeRepository errorTypeRepository, String errorTypeNames) {
        return TemplateOnErrorHandler.createErrorType(errorTypeRepository, errorTypeNames, new ConfigurationProperties(){

            public <T> Optional<T> resolveProperty(String propertyKey) {
                return Optional.empty();
            }

            public Optional<Boolean> resolveBooleanProperty(String property) {
                return Optional.empty();
            }

            public Optional<String> resolveStringProperty(String property) {
                return Optional.empty();
            }
        });
    }

    public void setWhen(String when) {
        this.when = Optional.ofNullable(when);
    }

    @Override
    public boolean accept(CoreEvent event) {
        return this.acceptsAll() || this.acceptsErrorType(event) && this.acceptsExpression(event);
    }

    private boolean acceptsErrorType(CoreEvent event) {
        return this.errorTypeMatcher == null || this.errorTypeMatcher.match(((Error)event.getError().get()).getErrorType());
    }

    private boolean acceptsExpression(CoreEvent event) {
        return !this.when.isPresent() || this.when.map(expr -> this.expressionManager.evaluateBoolean((String)expr, event, this.getLocation())).orElse(true) != false;
    }

    protected Function<CoreEvent, CoreEvent> afterRouting() {
        return event -> {
            if (event != null) {
                return this.nullifyExceptionPayloadIfRequired((CoreEvent)event);
            }
            return event;
        };
    }

    protected Function<CoreEvent, CoreEvent> beforeRouting() {
        return event -> {
            Exception exception = this.getException((CoreEvent)event);
            this.notificationFirer.dispatch((Notification)new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)exception, (Component)this.configuredMessageProcessors), this.location, 2001));
            this.fireNotification(exception, (CoreEvent)event);
            this.logException(exception, (CoreEvent)event);
            this.processStatistics();
            this.markExceptionAsHandledIfRequired(exception);
            return event;
        };
    }

    protected Exception getException(CoreEvent event) {
        return ErrorHandlerContextManager.from(this, event).getException();
    }

    protected void logException(Throwable t, CoreEvent event) {
        if (Boolean.TRUE.toString().equals(this.logException) || !Boolean.FALSE.toString().equals(this.logException) && this.expressionManager.evaluateBoolean(this.logException, event, this.location, true, true)) {
            this.resolveAndLogException(t);
        }
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public void setRootContainerName(String rootContainerName) {
        ComponentAnnotations.updateRootContainerName(rootContainerName, this);
    }

    protected void setFlowLocation(Location location) {
        this.flowLocation = Optional.ofNullable(location);
    }

    public abstract TemplateOnErrorHandler duplicateFor(Location var1);

    private boolean isTransactionInGlobalErrorHandler(TransactionAdapter transaction) {
        String transactionContainerName = transaction.getComponentLocation().get().getRootContainerName();
        return this.flowLocation.isPresent() && transactionContainerName.equals(this.flowLocation.get().getGlobalName());
    }

    protected boolean isOwnedTransaction() {
        TransactionAdapter transaction = (TransactionAdapter)TransactionCoordination.getInstance().getTransaction();
        if (transaction == null || !transaction.getComponentLocation().isPresent()) {
            return false;
        }
        if (this.inDefaultErrorHandler()) {
            return this.defaultErrorHandlerOwnsTransaction(transaction);
        }
        if (this.isTransactionInGlobalErrorHandler(transaction)) {
            return true;
        }
        if (this.flowLocation.isPresent()) {
            return false;
        }
        if (!this.isLocalErrorHandlerLocation) {
            return this.sameRootContainerLocation(transaction);
        }
        String transactionLocation = transaction.getComponentLocation().get().getLocation();
        return this.sameRootContainerLocation(transaction) && this.errorHandlerLocation.equals(transactionLocation);
    }

    private boolean sameRootContainerLocation(TransactionAdapter transaction) {
        String transactionContainerName = transaction.getComponentLocation().get().getRootContainerName();
        return transactionContainerName.equals(this.getRootContainerLocation().getGlobalName());
    }

    private boolean inDefaultErrorHandler() {
        return this.location == null;
    }

    private boolean defaultErrorHandlerOwnsTransaction(TransactionAdapter transaction) {
        String transactionLocation = transaction.getComponentLocation().get().getLocation();
        if (this.flowLocation.isPresent()) {
            return transactionLocation.equals(this.flowLocation.get().toString());
        }
        return this.sameRootContainerLocation(transaction);
    }

    protected ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepository;
    }

    private final class OnErrorHandlerFluxObjectFactory
    implements Function<Function<Publisher<CoreEvent>, Publisher<CoreEvent>>, FluxSink<CoreEvent>>,
    Disposable {
        private final Optional<ProcessingStrategy> processingStrategy;
        private final Set<FluxSink<CoreEvent>> fluxSinks = Collections.newSetFromMap(new ConcurrentHashMap());

        public OnErrorHandlerFluxObjectFactory(Optional<ProcessingStrategy> processingStrategy) {
            this.processingStrategy = processingStrategy;
        }

        @Override
        public FluxSink<CoreEvent> apply(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor) {
            FluxSinkRecorder sinkRef = new FluxSinkRecorder();
            Flux onErrorFlux = sinkRef.flux().map(TemplateOnErrorHandler.this.beforeRouting());
            if (!TemplateOnErrorHandler.this.getMessageProcessors().isEmpty()) {
                onErrorFlux = onErrorFlux.compose(TemplateOnErrorHandler.this::route);
            }
            onErrorFlux = Flux.from(publisherPostProcessor.apply((Publisher<CoreEvent>)onErrorFlux.onErrorContinue(MessagingException.class, TemplateOnErrorHandler.this.onRoutingError()).map(TemplateOnErrorHandler.this.afterRouting()).doOnNext(result -> {
                ErrorHandlerContextManager.ErrorHandlerContext errorHandlerContext = ErrorHandlerContextManager.from(TemplateOnErrorHandler.this, result);
                TemplateOnErrorHandler.this.fireEndNotification(errorHandlerContext.getOriginalEvent(), result, (Throwable)((Object)errorHandlerContext.getException()));
            }).doOnNext(result -> ErrorHandlerContextManager.resolveHandling((FlowExceptionHandler)TemplateOnErrorHandler.this, result)))).doAfterTerminate(() -> this.fluxSinks.remove(sinkRef.getFluxSink()));
            if (this.processingStrategy.isPresent()) {
                this.processingStrategy.get().registerInternalSink((Publisher<CoreEvent>)onErrorFlux, "error handler '" + TemplateOnErrorHandler.this.getLocation().getLocation() + "'");
            } else {
                onErrorFlux.subscribe();
            }
            FluxSink fluxSink = sinkRef.getFluxSink();
            this.fluxSinks.add(fluxSink);
            return fluxSink;
        }

        public void dispose() {
            this.fluxSinks.forEach(FluxSink::complete);
            this.fluxSinks.clear();
        }
    }
}

