/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.AbstractTypeRule;
import org.raml.yagi.framework.nodes.BooleanNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.DefaultSuggestion;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class BooleanTypeRule
extends AbstractTypeRule {
    public static final String STRICT_BOOLEANS = "org.raml.strict_booleans";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private final boolean strictBoolean;

    public BooleanTypeRule() {
        this.strictBoolean = Boolean.parseBoolean(System.getProperty(STRICT_BOOLEANS, FALSE));
    }

    BooleanTypeRule(boolean strictBoolean) {
        this.strictBoolean = strictBoolean;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Arrays.asList(new DefaultSuggestion(TRUE, "Boolean true", TRUE), new DefaultSuggestion(FALSE, "Boolean false", FALSE));
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (!this.strictBoolean && node instanceof StringNode) {
            String value = ((StringNode)node).getValue();
            return TRUE.equals(value) || FALSE.equals(value);
        }
        return node instanceof BooleanNode;
    }

    @Override
    public String getDescription() {
        return "Boolean";
    }

    @Override
    @Nonnull
    NodeType getType() {
        return NodeType.Boolean;
    }
}

