/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.core.api.MuleContext;

public class FeatureFlaggingRegistry {
    public static final String FEATURE_CAN_NOT_BE_NULL = "Feature can not be null";
    public static final String FEATURE_ALREADY_REGISTERED = "Feature %s already registered";
    public static final String CONDITION_CAN_NOT_BE_NULL = "Error registering %s: condition can not be null";
    private final Map<Feature, Predicate<MuleContext>> configurations = new ConcurrentHashMap<Feature, Predicate<MuleContext>>();
    private static final FeatureFlaggingRegistry INSTANCE = new FeatureFlaggingRegistry();

    public static FeatureFlaggingRegistry getInstance() {
        return INSTANCE;
    }

    private FeatureFlaggingRegistry() {
    }

    public void registerFeature(Feature feature, Predicate<MuleContext> condition) {
        if (feature == null) {
            throw new IllegalArgumentException(FEATURE_CAN_NOT_BE_NULL);
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format(CONDITION_CAN_NOT_BE_NULL, feature));
        }
        Predicate<MuleContext> added = this.configurations.putIfAbsent(feature, condition);
        if (added != null) {
            throw new IllegalArgumentException(String.format(FEATURE_ALREADY_REGISTERED, feature));
        }
    }

    public Map<Feature, Predicate<MuleContext>> getFeatureConfigurations() {
        return Collections.unmodifiableMap(this.configurations);
    }

    protected void clearFeatureConfigurations() {
        this.configurations.clear();
    }
}

