/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.mule.runtime.api.message.Message;

final class ResultToMessageListIterator
implements ListIterator<Message> {
    private final List<Message> delegate;
    private final int size;
    private int index;
    private int lastIndex = 0;

    ResultToMessageListIterator(List<Message> delegate) {
        this(delegate, 0);
    }

    ResultToMessageListIterator(List<Message> delegate, int startIndex) {
        this.delegate = delegate;
        this.index = startIndex;
        this.size = delegate.size();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public Message next() {
        this.lastIndex = this.index++;
        return this.delegate.get(this.lastIndex);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public Message previous() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        this.lastIndex = this.index - 1;
        return this.delegate.get(this.lastIndex);
    }

    @Override
    public int nextIndex() {
        return this.index < this.size ? this.index : this.size;
    }

    @Override
    public int previousIndex() {
        return this.index > 0 ? this.index - 1 : -1;
    }

    @Override
    public void remove() {
        this.delegate.remove(this.lastIndex);
    }

    @Override
    public void set(Message message) {
        this.delegate.set(this.lastIndex, message);
    }

    @Override
    public void add(Message message) {
        this.delegate.add(this.index, message);
    }
}

