/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.util.message.ResultToMessageListIterator;
import org.mule.runtime.core.internal.util.message.ResultsToMessageCollection;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class ResultsToMessageList
extends ResultsToMessageCollection
implements List<Message> {
    private final List<Object> delegate;

    public ResultsToMessageList(List<Object> delegate, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        super(delegate, cursorProviderFactory, eventContext, originatingLocation);
        this.delegate = delegate;
    }

    @Override
    public void add(int index, Message element) {
        this.writeLock.lock();
        try {
            this.delegate.add(index, element);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends Message> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.addAll(index, c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        this.readLock.lock();
        try {
            int i = this.delegate.indexOf(o);
            if (i == -1 && o instanceof Message) {
                i = this.delegate.indexOf(Result.builder((Message)((Message)o)).build());
            }
            int n = i;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        this.readLock.lock();
        try {
            int i = this.delegate.lastIndexOf(o);
            if (i == -1 && o instanceof Message) {
                i = this.delegate.lastIndexOf(Result.builder((Message)((Message)o)).build());
            }
            int n = i;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void sort(Comparator<? super Message> c) {
        this.writeLock.lock();
        try {
            this.delegate.sort((o1, o2) -> c.compare(this.toMessage(o1, this.cursorProviderFactory, this.eventContext), this.toMessage(o2, this.cursorProviderFactory, this.eventContext)));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message get(int index) {
        this.readLock.lock();
        try {
            Object update;
            block10: {
                Object value = this.delegate.get(index);
                if (value instanceof Message) {
                    Message message = (Message)value;
                    return message;
                }
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    update = this.delegate.get(index);
                    if (!(update instanceof Message)) break block10;
                    Message message = (Message)update;
                    this.readLock.lock();
                    this.writeLock.unlock();
                    return message;
                }
                catch (Throwable throwable) {
                    this.readLock.lock();
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            update = this.toMessage(update, this.cursorProviderFactory, this.eventContext);
            this.delegate.set(index, update);
            Message message = (Message)update;
            this.readLock.lock();
            this.writeLock.unlock();
            return message;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message set(int index, Message message) {
        this.writeLock.lock();
        try {
            Object previous = this.delegate.set(index, message);
            Message message2 = previous != null ? this.toMessage(previous, this.cursorProviderFactory, this.eventContext) : null;
            return message2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message remove(int index) {
        this.writeLock.lock();
        try {
            Object previous = this.delegate.remove(index);
            Message message = previous != null ? this.toMessage(previous, this.cursorProviderFactory, this.eventContext) : null;
            return message;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Iterator<Message> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Message> listIterator() {
        return new ResultToMessageListIterator(this);
    }

    @Override
    public ListIterator<Message> listIterator(int index) {
        return new ResultToMessageListIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> subList(int fromIndex, int toIndex) {
        this.readLock.lock();
        try {
            List<Object> results = this.delegate.subList(fromIndex, toIndex);
            ResultsToMessageList resultsToMessageList = new ResultsToMessageList(results, this.cursorProviderFactory, this.eventContext, this.originatingLocation);
            return resultsToMessageList;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

