/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.module.reader.CharsetHelper$;
import org.mule.weave.v2.module.reader.SourceReader;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\r\u001b\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)1\t\u0001C\u0001\t\"A\u0001\n\u0001EC\u0002\u0013\u0005\u0011\nC\u0004N\u0001\t\u0007I\u0011\u0002(\t\rM\u0003\u0001\u0015!\u0003P\u0011\u001d!\u0006A1A\u0005\n9Ca!\u0016\u0001!\u0002\u0013y\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u0007C\u0002\u0001\u000b\u0011\u0002-\t\u000f\t\u0004\u0001\u0019!C\u0001G\"9q\r\u0001a\u0001\n\u0003A\u0007B\u00028\u0001A\u0003&A\rC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003w\u0001\u0011\u0005s\u000fC\u0003|\u0001\u0011\u0005s\u000fC\u0003}\u0001\u0011\u0005\u0003\u000fC\u0003~\u0001\u0011\u0005c\u0010C\u0004\u0002\u0002\u0001!\t%a\u0001\t\r\u0005-\u0001\u0001\"\u0011q\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\f\u0001\t\u0003\n\t\u0004\u0003\u0004\u00028\u0001!\t%\u001e\u0002\u0017+R3\u0005h\u0015;sK\u0006l7k\\;sG\u0016\u0014V-\u00193fe*\u00111\u0004H\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005uq\u0012AB7pIVdWM\u0003\u0002 A\u0005\u0011aO\r\u0006\u0003C\t\nQa^3bm\u0016T!a\t\u0013\u0002\t5,H.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u000b\u0019\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u00027b]\u001eT\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t1qJ\u00196fGR\u0004\"!\r\u001a\u000e\u0003iI!a\r\u000e\u0003\u0019M{WO]2f%\u0016\fG-\u001a:\u0002\u001dM,Wm[1cY\u0016\u001cFO]3b[B\u0011a'O\u0007\u0002o)\u0011\u0001HH\u0001\u0003S>L!AO\u001c\u0003\u001dM+Wm[1cY\u0016\u001cFO]3b[\u000691\r[1sg\u0016$\bCA\u001fB\u001b\u0005q$BA\u001e@\u0015\t\u0001E&A\u0002oS>L!A\u0011 \u0003\u000f\rC\u0017M]:fi\u00061A(\u001b8jiz\"2!\u0012$H!\t\t\u0004\u0001C\u00035\u0007\u0001\u0007Q\u0007C\u0003<\u0007\u0001\u0007A(A\u0004eK\u000e|G-\u001a:\u0016\u0003)\u0003\"!P&\n\u00051s$AD\"iCJ\u001cX\r\u001e#fG>$WM]\u0001\u000bG\"\f'OQ;gM\u0016\u0014X#A(\u0011\u0005A\u000bV\"A \n\u0005I{$AC\"iCJ\u0014UO\u001a4fe\u0006Y1\r[1s\u0005V4g-\u001a:!\u0003E!WMZ1vYR\u001c\u0005.\u0019:Ck\u001a4WM]\u0001\u0013I\u00164\u0017-\u001e7u\u0007\"\f'OQ;gM\u0016\u0014\b%\u0001\teK\u001a\fW\u000f\u001c;CsR,\u0017I\u001d:bsV\t\u0001\fE\u0002Z9zk\u0011A\u0017\u0006\u00027\u0006)1oY1mC&\u0011QL\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00033~K!\u0001\u0019.\u0003\t\tKH/Z\u0001\u0012I\u00164\u0017-\u001e7u\u0005f$X-\u0011:sCf\u0004\u0013AC0sK\u0006$')\u001f;fgV\tA\r\u0005\u0002ZK&\u0011aM\u0017\u0002\u0004\u0013:$\u0018AD0sK\u0006$')\u001f;fg~#S-\u001d\u000b\u0003S2\u0004\"!\u00176\n\u0005-T&\u0001B+oSRDq!\u001c\u0007\u0002\u0002\u0003\u0007A-A\u0002yIE\n1b\u0018:fC\u0012\u0014\u0015\u0010^3tA\u0005I!/Z1e\u0003N\u001c\u0017.\u001b\u000b\u0002cB\u0011\u0011L]\u0005\u0003gj\u0013Aa\u00115be\u0006I\u0001.\u00198eY\u0016\u0014u*\u0014\u000b\u0002S\u0006A\u0001o\\:ji&|g\u000eF\u0001y!\tI\u00160\u0003\u0002{5\n!Aj\u001c8h\u0003A\u0001(/\u001a<j_V\u001c\bk\\:ji&|g.\u0001\bm_>\\\u0017\t[3bI\u0006\u001b8-[5\u0002\tM,Wm\u001b\u000b\u0003S~DQA^\nA\u0002a\fa\"\u001b8NK6|'/\u001f*fC\u0012,'\u000f\u0006\u0002\u0002\u0006A\u0019\u0011,a\u0002\n\u0007\u0005%!LA\u0004C_>dW-\u00198\u0002\tI,\u0017\rZ\u0001\u0012e\u0016\fG-\u00128d_\u0012,Gm\u0015;sS:<GCBA\t\u0003O\tY\u0003\u0005\u0003\u0002\u0014\u0005\u0005b\u0002BA\u000b\u0003;\u00012!a\u0006[\u001b\t\tIBC\u0002\u0002\u001c\u0019\na\u0001\u0010:p_Rt\u0014bAA\u00105\u00061\u0001K]3eK\u001aLA!a\t\u0002&\t11\u000b\u001e:j]\u001eT1!a\b[\u0011\u0019\tIC\u0006a\u0001q\u0006!aM]8n\u0011\u0019\tiC\u0006a\u0001q\u00061A.\u001a8hi\"\fqB]3bI\u0006\u001b8-[5TiJLgn\u001a\u000b\u0007\u0003#\t\u0019$!\u000e\t\r\u0005%r\u00031\u0001y\u0011\u0019\tic\u0006a\u0001q\u0006)1\r\\8tK\u0002")
public class UTF8StreamSourceReader
implements SourceReader {
    private CharsetDecoder decoder;
    private final SeekableStream seekableStream;
    private final Charset charset;
    private final CharBuffer charBuffer;
    private final CharBuffer defaultCharBuffer;
    private final byte[] defaultByteArray;
    private int _readBytes;
    private volatile boolean bitmap$0;

    @Override
    public boolean supportsSeek() {
        return SourceReader.supportsSeek$(this);
    }

    @Override
    public boolean requireClose() {
        return SourceReader.requireClose$(this);
    }

    private CharsetDecoder decoder$lzycompute() {
        UTF8StreamSourceReader uTF8StreamSourceReader = this;
        synchronized (uTF8StreamSourceReader) {
            if (!this.bitmap$0) {
                this.decoder = this.charset.newDecoder();
                this.bitmap$0 = true;
            }
        }
        return this.decoder;
    }

    public CharsetDecoder decoder() {
        return !this.bitmap$0 ? this.decoder$lzycompute() : this.decoder;
    }

    private CharBuffer charBuffer() {
        return this.charBuffer;
    }

    private CharBuffer defaultCharBuffer() {
        return this.defaultCharBuffer;
    }

    private byte[] defaultByteArray() {
        return this.defaultByteArray;
    }

    public int _readBytes() {
        return this._readBytes;
    }

    public void _readBytes_$eq(int x$1) {
        this._readBytes = x$1;
    }

    @Override
    public char readAscii() {
        char c;
        int read;
        if (this.seekableStream.position() == 0L) {
            this.handleBOM();
        }
        if ((read = ((InputStream)((Object)this.seekableStream)).read()) != -1) {
            this._readBytes_$eq(1);
            c = (char)(read & 0xFF);
        } else {
            this._readBytes_$eq(0);
            c = '\uffff';
        }
        return c;
    }

    public void handleBOM() {
        block0: {
            Option<byte[]> mayBeBom = CharsetHelper$.MODULE$.getBom(this.charset);
            byte[] bom = (byte[])mayBeBom.get();
            byte[] inputBom = new byte[bom.length];
            ((InputStream)((Object)this.seekableStream)).read(inputBom);
            if (inputBom[0] == bom[0] && inputBom[1] == bom[1] && inputBom[2] == bom[2]) break block0;
            this.seekableStream.seek(0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long position() {
        long l;
        long position = this.seekableStream.position();
        if (position == 0L) {
            this.handleBOM();
            l = this.seekableStream.position();
        } else {
            void var1_1;
            l = var1_1;
        }
        return l;
    }

    @Override
    public long previousPosition() {
        return this.position() - (long)this._readBytes();
    }

    @Override
    public char lookAheadAscii() {
        char c;
        long startPosition = this.position();
        try {
            c = this.readAscii();
        }
        finally {
            this.seek(startPosition);
        }
        return c;
    }

    @Override
    public void seek(long position) {
        this.seekableStream.seek(position);
    }

    @Override
    public boolean inMemoryReader() {
        return this.seekableStream.inMemoryStream();
    }

    @Override
    public char read() {
        char c;
        if (this.charBuffer().position() == this.charBuffer().length()) {
            c = this.charBuffer().get();
        } else {
            byte _read = (byte)((InputStream)((Object)this.seekableStream)).read();
            if (_read == -1) {
                this._readBytes_$eq(0);
                c = 65535;
            } else if (_read >= 0) {
                this._readBytes_$eq(1);
                c = (char)_read;
            } else if ((_read & 0xE0) == 192) {
                this._readBytes_$eq(2);
                c = this.decode$1(_read, 1);
            } else if ((_read & 0xF0) == 224) {
                this._readBytes_$eq(3);
                c = this.decode$1(_read, 2);
            } else if ((_read & 0xF8) == 240) {
                this._readBytes_$eq(4);
                c = this.decode$1(_read, 3);
            } else {
                c = (char)65533;
            }
        }
        return c;
    }

    @Override
    public String readEncodedString(long from, long length) {
        byte[] bytes = (long)this.defaultByteArray().length > length ? this.defaultByteArray() : new byte[(int)length];
        this.seek(from);
        int amount = ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        CharBuffer charBuffer = (long)this.defaultCharBuffer().capacity() < length ? CharBuffer.allocate((int)length) : this.defaultCharBuffer();
        charBuffer.clear();
        this.decoder().decode(ByteBuffer.wrap(bytes, 0, amount), charBuffer, true);
        int decodedLength = charBuffer.position();
        return new String(charBuffer.array(), 0, decodedLength);
    }

    @Override
    public String readAsciiString(long from, long length) {
        byte[] bytes = (long)this.defaultByteArray().length > length ? this.defaultByteArray() : new byte[(int)length];
        this.seek(from);
        int amount = ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        return new String(bytes, 0, amount, StandardCharsets.US_ASCII);
    }

    @Override
    public void close() {
        ((InputStream)((Object)this.seekableStream)).close();
    }

    private final char decode$1(byte by, int remainingBytes) {
        char c;
        this.charBuffer().clear();
        byte[] bytes = new byte[remainingBytes + 1];
        bytes[0] = by;
        int amountThatWasRead = ((InputStream)((Object)this.seekableStream)).read(bytes, 1, remainingBytes);
        CoderResult result = this.decoder().decode(ByteBuffer.wrap(bytes), this.charBuffer(), true);
        if (!result.isError()) {
            try {
                this.charBuffer().flip();
                c = this.charBuffer().get();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                this.seek(this.position() - (long)amountThatWasRead);
                c = this.read();
            }
        } else {
            this.seek(this.position() - (long)amountThatWasRead);
            c = this.read();
        }
        return c;
    }

    public UTF8StreamSourceReader(SeekableStream seekableStream, Charset charset) {
        this.seekableStream = seekableStream;
        this.charset = charset;
        SourceReader.$init$(this);
        this.charBuffer = CharBuffer.allocate(2);
        this.defaultCharBuffer = CharBuffer.allocate(8192);
        this.defaultByteArray = new byte[8192];
        this._readBytes = 0;
    }
}

