/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

public class SourcePolicyContext
implements EventInternalContext<SourcePolicyContext> {
    private final PolicyPointcutParameters pointcutParameters;
    private CoreEvent originalEvent;
    private MessageSourceResponseParametersProcessor responseParametersProcessor;
    private CompletableCallback<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> processCallback;
    private Map<String, Object> originalResponseParameters;
    private Map<String, Object> originalFailureResponseParameters;
    private Optional<SourcePolicyParametersTransformer> parametersTransformer = Optional.empty();
    private Map<String, Map<String, TypedValue<?>>> variables = new SmallMap();

    public static SourcePolicyContext from(CoreEvent event) {
        return (SourcePolicyContext)((InternalEvent)event).getSourcePolicyContext();
    }

    public SourcePolicyContext(PolicyPointcutParameters pointcutParameters) {
        this.pointcutParameters = pointcutParameters;
    }

    public void configure(MessageSourceResponseParametersProcessor responseParametersProcessor, CompletableCallback<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> callback) {
        this.responseParametersProcessor = responseParametersProcessor;
        this.processCallback = callback;
    }

    @Override
    public SourcePolicyContext copy() {
        return this;
    }

    public PolicyPointcutParameters getPointcutParameters() {
        return this.pointcutParameters;
    }

    public CoreEvent getOriginalEvent() {
        return this.originalEvent;
    }

    public void setOriginalEvent(CoreEvent originalEvent) {
        this.originalEvent = originalEvent;
    }

    public MessageSourceResponseParametersProcessor getResponseParametersProcessor() {
        return this.responseParametersProcessor;
    }

    public CompletableCallback<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> getProcessCallback() {
        return this.processCallback;
    }

    public Map<String, Object> getOriginalResponseParameters() {
        return this.originalResponseParameters;
    }

    public void setOriginalResponseParameters(Map<String, Object> originalResponseParameters) {
        this.originalResponseParameters = originalResponseParameters;
    }

    public Map<String, Object> getOriginalFailureResponseParameters() {
        return this.originalFailureResponseParameters;
    }

    public void setOriginalFailureResponseParameters(Map<String, Object> originalFailureResponseParameters) {
        this.originalFailureResponseParameters = originalFailureResponseParameters;
    }

    public void setParametersTransformer(Optional<SourcePolicyParametersTransformer> parametersTransformer) {
        this.parametersTransformer = parametersTransformer;
    }

    public Optional<SourcePolicyParametersTransformer> getParametersTransformer() {
        return this.parametersTransformer;
    }

    public Map<String, TypedValue<?>> getVariables(String policyId) {
        return this.variables.get(policyId);
    }

    public void addVariables(String policyId, Map<String, TypedValue<?>> variables) {
        this.variables.put(policyId, variables);
    }
}

