/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.construct.FromFlowRejectedExecutionException;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

abstract class AbstractReactorStreamProcessingStrategy
extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
implements Startable,
Stoppable,
Disposable {
    private final Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier;
    private final int parallelism;
    private final AtomicInteger inFlightEvents = new AtomicInteger();
    private final BiConsumer<CoreEvent, Throwable> inFlightDecrementCallback = (e, t) -> this.inFlightEvents.decrementAndGet();
    private org.mule.runtime.api.scheduler.Scheduler cpuLightScheduler;

    AbstractReactorStreamProcessingStrategy(int subscribers, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
        super(subscribers, maxConcurrency, maxConcurrencyEagerCheck);
        this.cpuLightSchedulerSupplier = cpuLightSchedulerSupplier;
        this.parallelism = parallelism;
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
            Scheduler cpuLiteScheduler = Schedulers.fromExecutorService((ExecutorService)this.getNonBlockingTaskScheduler());
            return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).publishOn(cpuLiteScheduler).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)this.getCpuLightScheduler()));
        }
        return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)this.getCpuLightScheduler()));
    }

    protected ScheduledExecutorService getNonBlockingTaskScheduler() {
        return this.decorateScheduler((ScheduledExecutorService)this.getCpuLightScheduler());
    }

    @Override
    public void checkBackpressureAccepting(CoreEvent event) throws RejectedExecutionException {
        BackPressureReason reason = this.checkCapacity(event);
        if (reason != null) {
            throw new FromFlowRejectedExecutionException(reason);
        }
    }

    @Override
    public BackPressureReason checkBackpressureEmitting(CoreEvent event) {
        return this.checkCapacity(event);
    }

    protected BackPressureReason checkCapacity(CoreEvent event) {
        if (this.maxConcurrencyEagerCheck) {
            if (this.inFlightEvents.incrementAndGet() > this.maxConcurrency) {
                this.inFlightEvents.decrementAndGet();
                return BackPressureReason.MAX_CONCURRENCY_EXCEEDED;
            }
            ((BaseEventContext)event.getContext()).onBeforeResponse(this.inFlightDecrementCallback);
        }
        return null;
    }

    protected int getParallelism() {
        return this.parallelism;
    }

    public void start() throws MuleException {
        this.cpuLightScheduler = this.createCpuLightScheduler(this.cpuLightSchedulerSupplier);
    }

    public void stop() {
        this.inFlightEvents.getAndSet(0);
    }

    protected org.mule.runtime.api.scheduler.Scheduler createCpuLightScheduler(Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier) {
        return cpuLightSchedulerSupplier.get();
    }

    public void dispose() {
        this.stopSchedulersIfNeeded();
    }

    protected boolean stopSchedulersIfNeeded() {
        if (this.cpuLightScheduler != null) {
            this.cpuLightScheduler.stop();
            this.cpuLightScheduler = null;
        }
        return true;
    }

    protected org.mule.runtime.api.scheduler.Scheduler getCpuLightScheduler() {
        return this.cpuLightScheduler;
    }

    protected int getBufferQueueSize() {
        return AbstractStreamProcessingStrategyFactory.DEFAULT_BUFFER_SIZE;
    }
}

