/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CollectionBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.EagerObjectCreator;
import org.mule.runtime.config.internal.dsl.spring.ExceptionStrategyRefBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.MapBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.MapEntryBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ObjectBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.internal.dsl.spring.PropertiesMapBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ReferenceBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.SimpleTypeBeanDefinitionCreator;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.w3c.dom.Element;

public class BeanDefinitionFactory {
    public static final String SPRING_PROTOTYPE_OBJECT = "prototype";
    public static final String SPRING_SINGLETON_OBJECT = "singleton";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String TARGET_TYPE = "targetType";
    public static final String CORE_ERROR_NS = "mule".toUpperCase();
    private final ImmutableSet<ComponentIdentifier> ignoredMuleCoreComponentIdentifiers = ImmutableSet.builder().add((Object)CoreDslConstants.MULE_IDENTIFIER).add((Object)CoreDslConstants.MULE_DOMAIN_IDENTIFIER).add((Object)CoreDslConstants.MULE_EE_DOMAIN_IDENTIFIER).add((Object)ApplicationModel.ERROR_MAPPING_IDENTIFIER).add((Object)ApplicationModel.DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.ANNOTATIONS_ELEMENT_IDENTIFIER).add((Object)ApplicationModel.DOC_DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.GLOBAL_PROPERTY_IDENTIFIER).build();
    private final Set<ComponentIdentifier> ignoredMuleExtensionComponentIdentifiers;
    private final ImmutableSet<ComponentIdentifier> customBuildersComponentIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.MULE_PROPERTIES_IDENTIFIER).add((Object)ApplicationModel.MULE_PROPERTY_IDENTIFIER).add((Object)ApplicationModel.OBJECT_IDENTIFIER).build();
    private final String artifactId;
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;
    private final BeanDefinitionCreator componentModelProcessor;
    private final ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
    private final ErrorTypeRepository errorTypeRepository;

    public BeanDefinitionFactory(String artifactId, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry, ErrorTypeRepository errorTypeRepository) {
        this.artifactId = artifactId;
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.componentModelProcessor = this.buildComponentModelProcessorChainOfResponsability();
        this.ignoredMuleExtensionComponentIdentifiers = new HashSet<ComponentIdentifier>();
        this.errorTypeRepository = errorTypeRepository;
        this.registerConfigurationPropertyProviders();
    }

    private void registerConfigurationPropertyProviders() {
        ServiceLoader<ConfigurationPropertiesProviderFactory> providerFactories = ServiceLoader.load(ConfigurationPropertiesProviderFactory.class);
        providerFactories.forEach(service -> this.ignoredMuleExtensionComponentIdentifiers.add(service.getSupportedComponentIdentifier()));
    }

    public boolean isComponentIgnored(ComponentIdentifier identifier) {
        return this.ignoredMuleCoreComponentIdentifiers.contains((Object)identifier) || this.ignoredMuleExtensionComponentIdentifiers.contains(identifier);
    }

    public BeanDefinition resolveComponentRecursively(SpringComponentModel componentModel, BeanDefinitionRegistry registry, BiConsumer<ComponentModel, BeanDefinitionRegistry> componentModelPostProcessor, BiFunction<Element, BeanDefinition, Either<BeanDefinition, BeanReference>> oldParsingMechanism, SpringConfigurationComponentLocator componentLocator) {
        List<ComponentModel> innerComponents = componentModel.getInnerComponents();
        if (!innerComponents.isEmpty()) {
            for (ComponentModel innerComponent : innerComponents) {
                this.resolveComponentRecursively((SpringComponentModel)innerComponent, registry, componentModelPostProcessor, oldParsingMechanism, componentLocator);
            }
        }
        return this.resolveComponent(componentModel, registry, componentModelPostProcessor, componentLocator);
    }

    private BeanDefinition resolveComponent(SpringComponentModel componentModel, BeanDefinitionRegistry registry, BiConsumer<ComponentModel, BeanDefinitionRegistry> componentDefinitionModelProcessor, SpringConfigurationComponentLocator componentLocator) {
        if (this.isComponentIgnored(componentModel.getIdentifier())) {
            return null;
        }
        this.resolveComponentBeanDefinition(componentModel);
        componentDefinitionModelProcessor.accept(componentModel, registry);
        this.processMuleConfiguration(componentModel, registry);
        this.processMuleSecurityManager(componentModel, registry);
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier()).ifPresent(componentBuildingDefinition -> {
            if (componentModel.getType() != null && Component.class.isAssignableFrom(componentModel.getType())) {
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_NAME, componentModel.getIdentifier(), componentModel);
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS, componentModel.getRawParameters().entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), componentModel);
                List errorMappingComponents = componentModel.getInnerComponents().stream().filter(innerComponent -> ApplicationModel.ERROR_MAPPING_IDENTIFIER.equals(innerComponent.getIdentifier())).collect(Collectors.toList());
                if (!errorMappingComponents.isEmpty()) {
                    ComponentModelHelper.addAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS, errorMappingComponents.stream().map(innerComponent -> {
                        Map<String, String> parameters = innerComponent.getRawParameters();
                        ComponentIdentifier source = parameters.containsKey(SOURCE_TYPE) ? ComponentIdentifier.buildFromStringRepresentation((String)parameters.get(SOURCE_TYPE)) : Errors.ComponentIdentifiers.Handleable.ANY;
                        ErrorType errorType = (ErrorType)this.errorTypeRepository.lookupErrorType(source).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find error '%s'.", (Object[])new Object[]{source})));
                        SingleErrorTypeMatcher errorTypeMatcher = new SingleErrorTypeMatcher(errorType);
                        ErrorType targetValue = this.resolveErrorType(parameters.get(TARGET_TYPE));
                        return new ErrorMapping((ErrorTypeMatcher)errorTypeMatcher, targetValue);
                    }).collect(Collectors.toList()), componentModel);
                }
                componentLocator.addComponentLocation((ComponentLocation)componentModel.getComponentLocation());
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG, componentModel, componentModel);
            }
        });
        ComponentModelHelper.addAnnotation(AbstractComponent.LOCATION_KEY, componentModel.getComponentLocation(), componentModel);
        ComponentModelHelper.addAnnotation(Component.Annotations.REPRESENTATION_ANNOTATION_KEY, BeanDefinitionFactory.resolveProcessorRepresentation(this.artifactId, componentModel.getComponentLocation(), componentModel.getMetadata()), componentModel);
        BeanDefinition beanDefinition = componentModel.getBeanDefinition();
        return beanDefinition;
    }

    private ErrorType resolveErrorType(String representation) {
        ComponentIdentifier errorIdentifier = BeanDefinitionFactory.parserErrorType(representation);
        if (CORE_ERROR_NS.equals(errorIdentifier.getNamespace())) {
            return (ErrorType)this.errorTypeRepository.lookupErrorType(errorIdentifier).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There's no MULE error named '%s'.", errorIdentifier.getName()))));
        }
        return (ErrorType)this.errorTypeRepository.lookupErrorType(errorIdentifier).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find synthetic error '%s' in registry", (Object[])new Object[]{errorIdentifier})));
    }

    public static ComponentIdentifier parserErrorType(String representation) {
        String identifier;
        String namespace;
        int separator = representation.indexOf(58);
        if (separator > 0) {
            namespace = representation.substring(0, separator).toUpperCase();
            identifier = representation.substring(separator + 1).toUpperCase();
        } else {
            namespace = CORE_ERROR_NS;
            identifier = representation.toUpperCase();
        }
        return ComponentIdentifier.builder().namespace(namespace).name(identifier).build();
    }

    public static String resolveProcessorRepresentation(String appId, DefaultComponentLocation processorPath, ComponentMetadataAst metadata) {
        Object docName;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(processorPath.getLocation()).append(" @ ").append(appId);
        String sourceFile = metadata.getFileName().orElse(null);
        if (sourceFile != null) {
            stringBuilder.append(":").append(sourceFile).append(":").append(metadata.getStartLine().orElse(-1));
        }
        if ((docName = metadata.getDocAttributes().get(Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart())) != null) {
            stringBuilder.append(" (").append(docName).append(")");
        }
        return stringBuilder.toString();
    }

    private void processMuleConfiguration(ComponentModel componentModel, BeanDefinitionRegistry registry) {
        if (componentModel.getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER)) {
            AtomicReference expressionLanguage = new AtomicReference();
            componentModel.getInnerComponents().stream().forEach(childComponentModel -> {
                if (CommonBeanDefinitionCreator.areMatchingTypes(MVELExpressionLanguage.class, childComponentModel.getType())) {
                    expressionLanguage.set(((SpringComponentModel)childComponentModel).getBeanDefinition());
                }
            });
            String defaultObjectSerializer = componentModel.getRawParameters().get("defaultObjectSerializer-ref");
            if (defaultObjectSerializer != null && defaultObjectSerializer != "_muleDefaultObjectSerializer") {
                registry.removeBeanDefinition("_muleDefaultObjectSerializer");
                registry.registerAlias(defaultObjectSerializer, "_muleDefaultObjectSerializer");
            }
            if (expressionLanguage.get() != null) {
                registry.registerBeanDefinition("_muleExpressionLanguage", (BeanDefinition)expressionLanguage.get());
            }
        }
    }

    private void processMuleSecurityManager(ComponentModel componentModel, BeanDefinitionRegistry registry) {
        if (componentModel.getIdentifier().equals(ApplicationModel.SECURITY_MANAGER_IDENTIFIER)) {
            componentModel.getInnerComponents().stream().forEach(childComponentModel -> {
                String identifier = childComponentModel.getIdentifier().getName();
                if (identifier.equals("password-encryption-strategy") || identifier.equals("secret-key-encryption-strategy")) {
                    registry.registerBeanDefinition(childComponentModel.getNameAttribute(), ((SpringComponentModel)childComponentModel).getBeanDefinition());
                }
            });
        }
    }

    private void resolveComponentBeanDefinition(SpringComponentModel componentModel) {
        Optional<ComponentBuildingDefinition<?>> buildingDefinitionOptional = this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier());
        if (buildingDefinitionOptional.isPresent() || this.customBuildersComponentIdentifiers.contains((Object)componentModel.getIdentifier())) {
            this.componentModelProcessor.processRequest(new CreateBeanDefinitionRequest(componentModel, buildingDefinitionOptional.orElse(null)));
        } else {
            this.processComponentWrapper(componentModel);
        }
    }

    private void processComponentWrapper(SpringComponentModel componentModel) {
        this.componentBuildingDefinitionRegistry.getWrappedComponent(componentModel.getIdentifier()).ifPresent(wrapperElementType -> {
            if (wrapperElementType.equals((Object)ComponentBuildingDefinitionRegistry.WrapperElementType.SINGLE)) {
                if (componentModel.getInnerComponents().isEmpty()) {
                    String location = componentModel.getComponentLocation() != null ? componentModel.getComponentLocation().getLocation() : "";
                    throw new IllegalStateException(String.format("Element [%s] located at [%s] does not have any child element declared, but one is required.", componentModel.getIdentifier(), location));
                }
            } else {
                throw new IllegalStateException(String.format("Element %s does not have a building definition and it should since it's of type %s", componentModel.getIdentifier(), wrapperElementType));
            }
            SpringComponentModel firstComponentModel = (SpringComponentModel)componentModel.getInnerComponents().get(0);
            componentModel.setType(firstComponentModel.getType());
            componentModel.setBeanDefinition(firstComponentModel.getBeanDefinition());
            componentModel.setBeanReference(firstComponentModel.getBeanReference());
        });
    }

    private BeanDefinitionCreator buildComponentModelProcessorChainOfResponsability() {
        EagerObjectCreator eagerObjectCreator = new EagerObjectCreator();
        ObjectBeanDefinitionCreator objectBeanDefinitionCreator = new ObjectBeanDefinitionCreator();
        ExceptionStrategyRefBeanDefinitionCreator exceptionStrategyRefBeanDefinitionCreator = new ExceptionStrategyRefBeanDefinitionCreator();
        PropertiesMapBeanDefinitionCreator propertiesMapBeanDefinitionCreator = new PropertiesMapBeanDefinitionCreator();
        ReferenceBeanDefinitionCreator referenceBeanDefinitionCreator = new ReferenceBeanDefinitionCreator();
        SimpleTypeBeanDefinitionCreator simpleTypeBeanDefinitionCreator = new SimpleTypeBeanDefinitionCreator();
        CollectionBeanDefinitionCreator collectionBeanDefinitionCreator = new CollectionBeanDefinitionCreator();
        MapEntryBeanDefinitionCreator mapEntryBeanDefinitionCreator = new MapEntryBeanDefinitionCreator();
        MapBeanDefinitionCreator mapBeanDefinitionCreator = new MapBeanDefinitionCreator();
        CommonBeanDefinitionCreator commonComponentModelProcessor = new CommonBeanDefinitionCreator(this.objectFactoryClassRepository);
        eagerObjectCreator.setNext(objectBeanDefinitionCreator);
        objectBeanDefinitionCreator.setNext(propertiesMapBeanDefinitionCreator);
        propertiesMapBeanDefinitionCreator.setNext(exceptionStrategyRefBeanDefinitionCreator);
        exceptionStrategyRefBeanDefinitionCreator.setNext(referenceBeanDefinitionCreator);
        referenceBeanDefinitionCreator.setNext(simpleTypeBeanDefinitionCreator);
        simpleTypeBeanDefinitionCreator.setNext(collectionBeanDefinitionCreator);
        collectionBeanDefinitionCreator.setNext(mapEntryBeanDefinitionCreator);
        mapEntryBeanDefinitionCreator.setNext(mapBeanDefinitionCreator);
        mapBeanDefinitionCreator.setNext(commonComponentModelProcessor);
        return eagerObjectCreator;
    }

    public boolean hasDefinition(ComponentIdentifier componentIdentifier) {
        return this.isComponentIgnored(componentIdentifier) || this.customBuildersComponentIdentifiers.contains((Object)componentIdentifier) || this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentIdentifier).isPresent() || this.componentBuildingDefinitionRegistry.getWrappedComponent(componentIdentifier).isPresent();
    }

    public boolean isLanguageConstructComponent(ComponentIdentifier componentIdentifier) {
        return this.customBuildersComponentIdentifiers.contains((Object)componentIdentifier);
    }
}

