/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.thread.notification;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.thread.notification.ThreadNotificationService;
import org.mule.runtime.core.internal.context.thread.notification.ThreadsStatistics;

public class DefaultThreadNotificationService
implements ThreadNotificationService,
Startable,
Stoppable {
    private static final String newLine = System.getProperty("line.separator");
    private ThreadsStatistics stats = new ThreadsStatistics();
    private int interval;
    private ScheduledFuture fixedRate;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    @Inject
    private MuleContext muleContext;

    public DefaultThreadNotificationService() {
        this(Integer.getInteger("mule.schedulers.latency.report.interval", -1));
    }

    public DefaultThreadNotificationService(int interval) {
        this.interval = interval;
    }

    @Override
    public void addThreadNotificationElement(ThreadNotificationService.ThreadNotificationElement notification) {
        this.stats.addThreadNotificationElement(notification);
    }

    @Override
    public void addThreadNotificationElements(Collection<ThreadNotificationService.ThreadNotificationElement> notifications) {
        this.stats.addThreadNotificationElements(notifications);
    }

    @Override
    public String getNotification() {
        String msg = "";
        for (Pair<String, String> transition : this.stats.getPossibleTransitions()) {
            msg = msg + this.getNotificationFor(transition);
        }
        return msg;
    }

    private String getNotificationFor(Pair<String, String> transition) {
        String count = this.formattedNumber(this.stats.getCount(transition));
        String mean = this.formattedNumber(this.stats.getMean(transition));
        String std = this.formattedNumber(this.stats.getStdDeviation(transition));
        String percentile = this.formattedNumber(this.stats.percentile(transition, 0.9));
        Function<String, String> pad = this.getPad(count, mean, std, percentile);
        String msg = newLine + "Stats for transition " + (String)transition.getFirst() + " - " + (String)transition.getSecond() + newLine;
        msg = msg + " Transitions count: " + pad.apply(count) + newLine;
        msg = msg + "              Mean: " + pad.apply(mean) + " nSecs" + newLine;
        msg = msg + "Standard Deviation: " + pad.apply(std) + " nSecs" + newLine;
        msg = msg + "    Percentile 90%: " + pad.apply(percentile) + " nSecs" + newLine;
        return msg;
    }

    @Override
    public void clear() {
        this.stats.clear();
    }

    private void logStats() {
        for (Pair<String, String> transition : this.stats.getPossibleTransitions()) {
            REPORT_LOGGER.warn(this.getNotificationFor(transition));
        }
    }

    private Function<String, String> getPad(String ... elements) {
        Integer size = Arrays.stream(elements).map(element -> element.length()).max(Integer::compare).get();
        return value -> StringUtils.leftPad((String)value, (int)size);
    }

    private String formattedNumber(double nanos) {
        return String.format("%,d", new Double(nanos).intValue());
    }

    public void start() throws MuleException {
        if (this.muleContext.getConfiguration().isThreadLoggingEnabled() && this.interval > 0 && this.schedulerService != null) {
            this.scheduler = this.schedulerService.cpuLightScheduler();
            this.fixedRate = this.scheduler.scheduleAtFixedRate(() -> this.logStats(), (long)this.interval, (long)this.interval, TimeUnit.SECONDS);
        }
    }

    public void stop() throws MuleException {
        if (this.fixedRate != null) {
            this.fixedRate.cancel(true);
            this.scheduler.stop();
        }
    }
}

