/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.store;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.store.PartitionedPersistentObjectStore;
import org.mule.runtime.core.internal.util.store.PersistentObjectStorePartition;
import org.mule.runtime.core.internal.util.store.PersistentObjectStorePartitionData;

public class SharedPartitionedPersistentObjectStore<T extends Serializable>
extends PartitionedPersistentObjectStore<T> {
    public static final String SHARED_PERSISTENT_OBJECT_STORE_KEY = "_defaultSharedPersistentObjectStore";
    private static Map<String, PersistentObjectStorePartition> partitionsByName = new ConcurrentHashMap<String, PersistentObjectStorePartition>(){

        @Override
        public PersistentObjectStorePartition put(String key, PersistentObjectStorePartition value) {
            return super.put(key, new PersistentObjectStorePartitionData(value.getPartitionName(), value.getPartitionDirectory()));
        }

        @Override
        public PersistentObjectStorePartition putIfAbsent(String key, PersistentObjectStorePartition value) {
            return super.putIfAbsent(key, new PersistentObjectStorePartitionData(value.getPartitionName(), value.getPartitionDirectory()));
        }
    };
    private File workingDirectory;
    private Lock lock;

    public SharedPartitionedPersistentObjectStore(File workingDirectory, LockFactory lockFactory) {
        super(partitionsByName);
        Preconditions.checkArgument((workingDirectory != null ? 1 : 0) != 0, (String)"workingDirectory cannot be null");
        this.workingDirectory = workingDirectory;
        this.lock = lockFactory.createLock(this.getWorkingDirectory());
    }

    @Override
    protected PersistentObjectStorePartition<T> getPartitionObjectStore(String partitionName) throws ObjectStoreException {
        PersistentObjectStorePartition partitionObjectStore = super.getPartitionObjectStore(partitionName);
        return new PersistentObjectStorePartition(this.muleContext, partitionName, partitionObjectStore.getPartitionDirectory());
    }

    @Override
    public void open() throws ObjectStoreException {
        this.lock.lock();
        try {
            super.open();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void open(String partitionName) throws ObjectStoreException {
        this.lock.lock();
        try {
            super.open(partitionName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T doRemove(String key, String partitionName) throws ObjectStoreException {
        this.lock.lock();
        try {
            Object t = super.doRemove(key, partitionName);
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(long entryTTL, int maxEntries) throws ObjectStoreException {
        this.lock.lock();
        try {
            super.expire(entryTTL, maxEntries);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(long entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
        this.lock.lock();
        try {
            super.expire(entryTTL, maxEntries, partitionName);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected String getWorkingDirectory() {
        return this.workingDirectory.getAbsolutePath();
    }
}

