/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.execution;

import javax.transaction.TransactionManager;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.SingleResourceTransactionFactoryManager;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.execution.BeginAndResolveTransactionInterceptor;
import org.mule.runtime.core.internal.execution.ExecuteCallbackInterceptor;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.mule.runtime.core.internal.execution.IsolateCurrentTransactionInterceptor;
import org.mule.runtime.core.internal.execution.SuspendXaTransactionInterceptor;
import org.mule.runtime.core.internal.execution.ValidateTransactionalStateInterceptor;
import org.mule.runtime.core.internal.execution.compatibility.ResolvePreviousTransactionInterceptor;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public final class TransactionalExecutionTemplate<T>
implements ExecutionTemplate<T> {
    private ExecutionInterceptor<T> executionInterceptor;

    private TransactionalExecutionTemplate(String applicationName, NotificationDispatcher notificationDispatcher, SingleResourceTransactionFactoryManager transactionFactoryManager, TransactionManager transactionManager, TransactionConfig transactionConfig) {
        this(applicationName, notificationDispatcher, transactionFactoryManager, transactionManager, transactionConfig, true, false);
    }

    private TransactionalExecutionTemplate(String applicationName, NotificationDispatcher notificationDispatcher, SingleResourceTransactionFactoryManager transactionFactoryManager, TransactionManager transactionManager, TransactionConfig transactionConfig, boolean resolveAnyTransaction, boolean resolvePreviousTx) {
        if (transactionConfig == null) {
            transactionConfig = new MuleTransactionConfig();
        }
        boolean processTransactionOnException = true;
        ExecutionInterceptor tempExecutionInterceptor = new ExecuteCallbackInterceptor();
        tempExecutionInterceptor = new BeginAndResolveTransactionInterceptor(tempExecutionInterceptor, transactionConfig, applicationName, notificationDispatcher, transactionFactoryManager, transactionManager, true, resolveAnyTransaction);
        if (resolvePreviousTx) {
            tempExecutionInterceptor = new ResolvePreviousTransactionInterceptor(tempExecutionInterceptor, transactionConfig);
        }
        tempExecutionInterceptor = new SuspendXaTransactionInterceptor(tempExecutionInterceptor, transactionConfig, true);
        tempExecutionInterceptor = new ValidateTransactionalStateInterceptor(tempExecutionInterceptor, transactionConfig, resolvePreviousTx);
        this.executionInterceptor = new IsolateCurrentTransactionInterceptor(tempExecutionInterceptor, transactionConfig);
    }

    public static <T> TransactionalExecutionTemplate<T> createTransactionalExecutionTemplate(MuleContext muleContext, TransactionConfig transactionConfig) {
        return new TransactionalExecutionTemplate<T>(TransactionalExecutionTemplate.getApplicationName(muleContext), TransactionalExecutionTemplate.getNotificationDispatcher((MuleContextWithRegistry)muleContext), muleContext.getTransactionFactoryManager(), muleContext.getTransactionManager(), transactionConfig);
    }

    public static <T> TransactionalExecutionTemplate<T> createCompatibilityExecutionTemplate(MuleContext muleContext, TransactionConfig transactionConfig) {
        return new TransactionalExecutionTemplate<T>(TransactionalExecutionTemplate.getApplicationName(muleContext), TransactionalExecutionTemplate.getNotificationDispatcher((MuleContextWithRegistry)muleContext), muleContext.getTransactionFactoryManager(), muleContext.getTransactionManager(), transactionConfig, true, true);
    }

    private static NotificationDispatcher getNotificationDispatcher(MuleContextWithRegistry muleContext) {
        try {
            return muleContext.getRegistry().lookupObject(NotificationDispatcher.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
    }

    private static String getApplicationName(MuleContext muleContext) {
        return muleContext.getConfiguration().getId();
    }

    public static <T> TransactionalExecutionTemplate<T> createScopeTransactionalExecutionTemplate(MuleContext muleContext, TransactionConfig transactionConfig) {
        return new TransactionalExecutionTemplate<T>(TransactionalExecutionTemplate.getApplicationName(muleContext), TransactionalExecutionTemplate.getNotificationDispatcher((MuleContextWithRegistry)muleContext), muleContext.getTransactionFactoryManager(), muleContext.getTransactionManager(), transactionConfig, false, false);
    }

    @Override
    public T execute(ExecutionCallback<T> executionCallback) throws Exception {
        return this.executionInterceptor.execute(executionCallback, new ExecutionContext());
    }
}

