/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel;

import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.context.MessageContext;
import org.mule.runtime.core.internal.el.mvel.MuleBaseVariableResolverFactory;
import org.mule.runtime.core.internal.el.mvel.MuleImmutableVariableResolver;
import org.mule.runtime.core.internal.el.mvel.MuleVariableResolver;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.el.context.EventVariablesMapContext;
import org.mule.runtime.core.privileged.el.context.SessionVariableMapContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class MessageVariableResolverFactory
extends MuleBaseVariableResolverFactory {
    private static final long serialVersionUID = -6819292692339684915L;
    private static final String MESSAGE = "message";
    private static final String EXCEPTION = "exception";
    private static final String ERROR = "error";
    public static final String PAYLOAD = "payload";
    public static final String ATTRIBUTES = "attributes";
    public static final String MESSAGE_PAYLOAD = "message.payload";
    public static final String FLOW_VARS = "flowVars";
    public static final String SESSION_VARS = "sessionVars";
    protected PrivilegedEvent event;
    protected PrivilegedEvent.Builder eventBuilder;
    protected MuleContext muleContext;

    public MessageVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, PrivilegedEvent event, PrivilegedEvent.Builder eventBuilder) {
        this.event = event;
        this.eventBuilder = eventBuilder;
        this.muleContext = muleContext;
    }

    public MessageVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, PrivilegedEvent event, PrivilegedEvent.Builder eventBuilder, VariableResolverFactory next) {
        this(parserConfiguration, muleContext, event, eventBuilder);
        this.setNextFactory(next);
    }

    @Override
    public boolean isTarget(String name) {
        return MESSAGE.equals(name) || PAYLOAD.equals(name) || ATTRIBUTES.equals(name) || FLOW_VARS.equals(name) || EXCEPTION.equals(name) || ERROR.equals(name) || SESSION_VARS.equals(name) || "_muleMessage".equals(name);
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.event != null) {
            if (MESSAGE.equals(name)) {
                return new MuleImmutableVariableResolver<MessageContext>(MESSAGE, new MessageContext(this.event, this.eventBuilder, this.muleContext), null);
            }
            if (PAYLOAD.equals(name)) {
                return new MuleVariableResolver<Object>(PAYLOAD, new MessageContext(this.event, this.eventBuilder, this.muleContext).getPayload(), null, (name1, value, newValue) -> this.eventBuilder.message(Message.builder((Message)this.event.getMessage()).value(newValue).build()));
            }
            if (ATTRIBUTES.equals(name)) {
                return new MuleImmutableVariableResolver<Object>(ATTRIBUTES, this.event.getMessage().getAttributes().getValue(), null);
            }
            if (FLOW_VARS.equals(name)) {
                return new MuleImmutableVariableResolver<EventVariablesMapContext>(FLOW_VARS, new EventVariablesMapContext(this.event, this.eventBuilder), null);
            }
            if (EXCEPTION.equals(name)) {
                if (this.event.getError().isPresent()) {
                    Throwable exception = ((Error)this.event.getError().get()).getCause();
                    return new MuleImmutableVariableResolver<MessagingException>(EXCEPTION, this.wrapIfNecessary(this.event, exception), null);
                }
                return new MuleImmutableVariableResolver<Object>(EXCEPTION, null, null);
            }
            if (ERROR.equals(name)) {
                if (this.event.getError().isPresent()) {
                    return new MuleImmutableVariableResolver(ERROR, this.event.getError().get(), null);
                }
                return new MuleImmutableVariableResolver<Object>(ERROR, null, null);
            }
            if (SESSION_VARS.equals(name)) {
                return new MuleImmutableVariableResolver<SessionVariableMapContext>(SESSION_VARS, new SessionVariableMapContext(this.event.getSession()), null);
            }
            if ("_muleMessage".equals(name)) {
                return new MuleImmutableVariableResolver<Message>("_muleMessage", this.event.getMessage(), null);
            }
        }
        return super.getNextFactoryVariableResolver(name);
    }

    private MessagingException wrapIfNecessary(CoreEvent event, Throwable exception) {
        if (exception instanceof MessagingException) {
            return (MessagingException)((Object)exception);
        }
        return new MessagingException(event, exception);
    }
}

