/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.routing.AbstractForkJoinRouter;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.forkjoin.CollectMapForkJoinStrategyFactory;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ScatterGatherRouter
extends AbstractForkJoinRouter
implements Router {
    private List<MessageProcessorChain> routes = Collections.emptyList();
    @Inject
    ConfigurationProperties configurationProperties;

    @Override
    protected Consumer<CoreEvent> onEvent() {
        return event -> ScatterGatherRouter.validateMessageIsNotConsumable(event.getMessage());
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.routes.size() < 2 && !LifecycleUtils.isLazyInitMode(this.configurationProperties)) {
            throw new InitialisationException(CoreMessages.noEndpointsForRouter(), null);
        }
    }

    @Override
    protected Publisher<ForkJoinStrategy.RoutingPair> getRoutingPairs(CoreEvent event) {
        return Flux.fromIterable(this.routes).map(route -> ForkJoinStrategy.RoutingPair.of(event, route));
    }

    @Override
    protected List<MessageProcessorChain> getOwnedObjects() {
        return this.routes;
    }

    public void setRoutes(List<MessageProcessorChain> routes) {
        Preconditions.checkArgument((routes.size() > 1 || LifecycleUtils.isLazyInitMode(this.configurationProperties) ? 1 : 0) != 0, (String)"At least 2 routes are required for ScatterGather");
        this.routes = routes;
    }

    @Override
    protected boolean isDelayErrors() {
        return true;
    }

    @Override
    protected int getDefaultMaxConcurrency() {
        return this.routes.size();
    }

    @Override
    protected ForkJoinStrategyFactory getDefaultForkJoinStrategyFactory() {
        return new CollectMapForkJoinStrategyFactory();
    }

    public static void validateMessageIsNotConsumable(Message message) {
        if (message.getPayload().getDataType().isStreamType()) {
            throw new MuleRuntimeException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getDataType().getType().getName()));
        }
    }
}

