/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.event.EventInternalContextResolver;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.internal.exception.SuppressedMuleException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class UntilSuccessfulRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UntilSuccessfulRouter.class);
    static final String RETRY_CTX_INTERNAL_PARAM_KEY = "untilSuccessful.router.retryContext";
    private static final String UNTIL_SUCCESSFUL_MSG_PREFIX = "'until-successful' retries exhausted. Last exception message was: %s";
    private final EventInternalContextResolver<Map<String, RetryContext>> retryContextResolver;
    private final Component owner;
    private final Predicate<CoreEvent> shouldRetry;
    private final ConditionalExecutorServiceDecorator delayScheduler;
    private final Flux<CoreEvent> upstreamFlux;
    private final Flux<CoreEvent> innerFlux;
    private final Flux<CoreEvent> downstreamFlux;
    private final FluxSinkRecorder<CoreEvent> innerRecorder = new FluxSinkRecorder();
    private final FluxSinkRecorder<Either<Throwable, CoreEvent>> downstreamRecorder = new FluxSinkRecorder();
    private final AtomicReference<Context> downstreamCtxReference = new AtomicReference<Context>(Context.empty());
    private Function<ExpressionManagerSession, Integer> maxRetriesSupplier;
    private Function<ExpressionManagerSession, Integer> delaySupplier;
    private Function<CoreEvent, ExpressionManagerSession> sessionSupplier;
    private final AtomicInteger inflightEvents = new AtomicInteger(0);
    private final AtomicBoolean completeDeferred = new AtomicBoolean(false);

    UntilSuccessfulRouter(Component owner, Publisher<CoreEvent> publisher, Processor nestedChain, ProcessingStrategy processingStrategy, ExtendedExpressionManager expressionManager, Predicate<CoreEvent> shouldRetry, Scheduler delayScheduler, String maxRetries, String millisBetweenRetries) {
        this.owner = owner;
        this.shouldRetry = shouldRetry;
        this.delayScheduler = new ConditionalExecutorServiceDecorator((ScheduledExecutorService)delayScheduler, s -> TransactionCoordination.isTransactionActive());
        this.retryContextResolver = new EventInternalContextResolver<Map>(RETRY_CTX_INTERNAL_PARAM_KEY, HashMap::new);
        this.upstreamFlux = Flux.from(publisher).doOnNext(event -> {
            RetryContext ctx = new RetryContext((CoreEvent)event, this.sessionSupplier, this.maxRetriesSupplier, this.delaySupplier);
            this.inflightEvents.getAndIncrement();
            this.innerRecorder.next(this.eventWithCurrentContext((CoreEvent)event, ctx));
        }).doOnComplete(() -> {
            if (this.inflightEvents.get() == 0) {
                this.completeRouter();
            } else {
                this.completeDeferred.set(true);
            }
        });
        this.innerFlux = Flux.from(processingStrategy.configureInternalPublisher((Publisher<CoreEvent>)this.innerRecorder.flux())).transform(innerPublisher -> MessageProcessors.applyWithChildContext((Publisher<CoreEvent>)innerPublisher, nestedChain, Optional.of(owner.getLocation()))).doOnNext(successfulEvent -> {
            this.downstreamRecorder.next((Either<Throwable, CoreEvent>)Either.right(Throwable.class, (Object)this.eventWithCurrentContextDeleted((CoreEvent)successfulEvent)));
            this.completeRouterIfNecessary();
        }).onErrorContinue(this.getRetryPredicate(), this.getRetryHandler());
        this.downstreamFlux = Flux.create(sink -> {
            this.downstreamRecorder.accept((FluxSink<Either<Throwable, CoreEvent>>)sink);
            this.subscribeUpstreamChains(this.downstreamCtxReference.get());
        }).doOnNext(event -> this.inflightEvents.decrementAndGet()).map(this.getScopeResultMapper());
        this.maxRetriesSupplier = expressionManager.isExpression(maxRetries) ? this.expressionToIntegerSupplierFor(maxRetries) : session -> Integer.parseInt(maxRetries);
        this.delaySupplier = expressionManager.isExpression(millisBetweenRetries) ? this.expressionToIntegerSupplierFor(millisBetweenRetries) : session -> Integer.parseInt(millisBetweenRetries);
        this.sessionSupplier = !expressionManager.isExpression(maxRetries) && !expressionManager.isExpression(millisBetweenRetries) ? event -> null : event -> expressionManager.openSession(owner.getLocation(), (CoreEvent)event, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    private Function<Either<Throwable, CoreEvent>, CoreEvent> getScopeResultMapper() {
        return either -> {
            if (either.isLeft()) {
                throw Exceptions.propagate((Throwable)((Throwable)either.getLeft()));
            }
            return (CoreEvent)either.getRight();
        };
    }

    private BiConsumer<Throwable, Object> getRetryHandler() {
        return (error, offendingEvent) -> {
            MessagingException messagingError = (MessagingException)((Object)((Object)error));
            RetryContext ctx = this.getRetryContextForEvent(messagingError.getEvent());
            int retriesLeft = ctx.retryCount.getAndDecrement();
            if (retriesLeft > 0) {
                LOGGER.error("Retrying execution of event, attempt {} of {}.", (Object)ctx.getAttemptNumber(), ctx.maxRetries != -1 ? ctx.maxRetries : "unlimited");
                this.delayScheduler.schedule(() -> this.innerRecorder.next(this.eventWithCurrentContext(ctx.event, ctx)), (long)ctx.delayInMillis.intValue(), TimeUnit.MILLISECONDS);
            } else {
                LOGGER.error("Retry attempts exhausted. Failing...");
                Throwable resolvedError = this.getThrowableFunction(ctx.event).apply((Throwable)error);
                this.eventWithCurrentContextDeleted(messagingError.getEvent());
                this.downstreamRecorder.next((Either<Throwable, CoreEvent>)Either.left((Object)resolvedError, CoreEvent.class));
                this.completeRouterIfNecessary();
            }
        };
    }

    private void completeRouterIfNecessary() {
        if (this.completeDeferred.get() && this.inflightEvents.get() == 0) {
            this.completeRouter();
        }
    }

    private void completeRouter() {
        this.innerRecorder.complete();
        this.downstreamRecorder.complete();
    }

    Publisher<CoreEvent> getDownstreamPublisher() {
        return this.downstreamFlux.compose(downstreamPublisher -> Mono.subscriberContext().flatMapMany(downstreamContext -> downstreamPublisher.doOnSubscribe(s -> this.downstreamCtxReference.set((Context)downstreamContext))));
    }

    private void subscribeUpstreamChains(Context downstreamContext) {
        this.innerFlux.subscriberContext(downstreamContext).subscribe();
        this.upstreamFlux.subscriberContext(downstreamContext).subscribe();
    }

    private RetryContext getRetryContextForEvent(CoreEvent event) {
        return this.retryContextResolver.getCurrentContextFromEvent(event).get(event.getContext().getId());
    }

    private CoreEvent eventWithCurrentContext(CoreEvent event, RetryContext ctx) {
        Map<String, RetryContext> retryCtxContainer = this.retryContextResolver.getCurrentContextFromEvent(event);
        retryCtxContainer.put(event.getContext().getId(), ctx);
        return this.retryContextResolver.eventWithContext(event, retryCtxContainer);
    }

    private CoreEvent eventWithCurrentContextDeleted(CoreEvent event) {
        Map<String, RetryContext> retryCtxContainer = this.retryContextResolver.getCurrentContextFromEvent(event);
        retryCtxContainer.remove(event.getContext().getId());
        return this.retryContextResolver.eventWithContext(event, retryCtxContainer);
    }

    private Predicate<Throwable> getRetryPredicate() {
        return e -> e instanceof MessagingException && this.shouldRetry.test(((MessagingException)((Object)((Object)e))).getEvent());
    }

    private Function<Throwable, Throwable> getThrowableFunction(CoreEvent event) {
        return throwable -> {
            Throwable cause = ExceptionUtils.getMessagingExceptionCause(throwable);
            CoreEvent exceptionEvent = event;
            if (throwable instanceof MessagingException) {
                exceptionEvent = ((MessagingException)((Object)((Object)throwable))).getEvent();
            }
            return new MessagingException(exceptionEvent, (Throwable)((Object)new RetryPolicyExhaustedException(I18nMessageFactory.createStaticMessage((String)UNTIL_SUCCESSFUL_MSG_PREFIX, (Object[])new Object[]{cause.getMessage()}), (Throwable)new SuppressedMuleException(cause), this.owner)), this.owner);
        };
    }

    private Function<ExpressionManagerSession, Integer> expressionToIntegerSupplierFor(String anExpression) {
        return session -> {
            try {
                return (Integer)session.evaluate(anExpression, DataType.NUMBER).getValue();
            }
            catch (Exception evaluationException) {
                throw new RetryContextInitializationException(evaluationException);
            }
        };
    }

    static class RetryContextInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = -399718600886069735L;

        public RetryContextInitializationException(Throwable cause) {
            super(cause);
        }
    }

    private static class RetryContext {
        CoreEvent event;
        AtomicInteger retryCount = new AtomicInteger();
        Integer delayInMillis;
        Integer maxRetries;

        RetryContext(CoreEvent event, Function<CoreEvent, ExpressionManagerSession> sessionSupplier, Function<ExpressionManagerSession, Integer> maxRetriesSupplier, Function<ExpressionManagerSession, Integer> delayTimeSupplier) {
            this.event = event;
            ExpressionManagerSession session = sessionSupplier.apply(event);
            this.maxRetries = maxRetriesSupplier.apply(session);
            this.delayInMillis = delayTimeSupplier.apply(session);
            this.retryCount.set(this.maxRetries);
        }

        int getAttemptNumber() {
            return this.maxRetries - this.retryCount.get();
        }
    }
}

