/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.extension;

import com.google.common.collect.ImmutableSet;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.source.scheduler.CronScheduler;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.extension.api.declaration.type.DynamicConfigExpirationTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.internal.property.TargetModelProperty;
import org.mule.runtime.internal.dsl.DslConstants;

class MuleExtensionModelDeclarer {
    final ErrorModel anyError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build();
    final ErrorModel routingError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ROUTING).withParent(this.anyError).build();
    final ErrorModel compositeRoutingError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.COMPOSITE_ROUTING).withParent(this.routingError).build();
    final ErrorModel validationError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.VALIDATION).withParent(this.anyError).build();
    final ErrorModel duplicateMessageError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.DUPLICATE_MESSAGE).withParent(this.validationError).build();
    static final String DEFAULT_LOG_LEVEL = "INFO";

    MuleExtensionModelDeclarer() {
    }

    ExtensionDeclarer createExtensionModel() {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionModelDeclarer.class.getClassLoader());
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer().named("mule").describedAs("Mule Runtime and Integration Platform: Core components").onVersion(MuleExtensionModelProvider.MULE_VERSION).fromVendor("MuleSoft, Inc.").withCategory(Category.COMMUNITY).withModelProperty((ModelProperty)new CustomBuildingDefinitionProviderModelProperty()).withXmlDsl(XmlDslModel.builder().setPrefix("mule").setNamespace(DslConstants.CORE_NAMESPACE).setSchemaVersion(MuleExtensionModelProvider.MULE_VERSION).setXsdFileName("mule.xsd").setSchemaLocation(DslConstants.CORE_SCHEMA_LOCATION).build());
        this.declareExportedTypes(typeLoader, extensionDeclarer);
        this.declareObject(extensionDeclarer, typeLoader);
        this.declareFlow(extensionDeclarer, typeLoader);
        this.declareSubflow(extensionDeclarer, typeLoader);
        this.declareChoice(extensionDeclarer, typeLoader);
        this.declareErrorHandler(extensionDeclarer, typeLoader);
        this.declareTry(extensionDeclarer, typeLoader);
        this.declareScatterGather(extensionDeclarer, typeLoader);
        this.declareParallelForEach(extensionDeclarer, typeLoader);
        this.declareFirstSuccessful(extensionDeclarer);
        this.declareRoundRobin(extensionDeclarer);
        this.declareConfiguration(extensionDeclarer, typeLoader);
        this.declareConfigurationProperties(extensionDeclarer, typeLoader);
        this.declareAsync(extensionDeclarer, typeLoader);
        this.declareForEach(extensionDeclarer, typeLoader);
        this.declareUntilSuccessful(extensionDeclarer, typeLoader);
        this.declareFlowRef(extensionDeclarer, typeLoader);
        this.declareIdempotentValidator(extensionDeclarer, typeLoader);
        this.declareLogger(extensionDeclarer, typeLoader);
        this.declareSetPayload(extensionDeclarer, typeLoader);
        this.declareSetVariable(extensionDeclarer, typeLoader);
        this.declareRemoveVariable(extensionDeclarer, typeLoader);
        this.declareParseTemplate(extensionDeclarer, typeLoader);
        this.declareRaiseError(extensionDeclarer, typeLoader);
        this.declareScheduler(extensionDeclarer, typeLoader);
        this.declareErrors(extensionDeclarer);
        return extensionDeclarer;
    }

    private void declareObject(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer object = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("object").allowingTopLevelDefinition().describedAs("Element to declare a java object. Objects declared globally can be referenced from other parts of the configuration or recovered programmatically through org.mule.runtime.api.artifact.Registry.")).withDeprecation((DeprecationModel)new ImmutableDeprecationModel("Only meant to be used for backwards compatibility.", "4.0", "5.0"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)object.onDefaultParameterGroup().withOptionalParameter("name").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Name to use to reference this object.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)object.onDefaultParameterGroup().withOptionalParameter("ref").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("@Deprecated since 4.0. Only meant to be used for backwards compatibility. Reference to another object defined in the mule configuration or any other provider of objects.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)object.onDefaultParameterGroup().withOptionalParameter("class").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Creates an instance of the class provided as argument.");
        object.onDefaultParameterGroup().withExclusiveOptionals((Set)ImmutableSet.of((Object)"ref", (Object)"class"), true);
    }

    private void declareExportedTypes(ClassTypeLoader typeLoader, ExtensionDeclarer extensionDeclarer) {
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)typeLoader.load(ObjectStore.class));
    }

    private void declareScheduler(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        SourceDeclarer scheduler = (SourceDeclarer)extensionDeclarer.withMessageSource("scheduler").hasResponse(false).describedAs("Source that schedules periodic execution of a flow.");
        scheduler.withOutput().ofType(typeLoader.load(Object.class));
        scheduler.withOutputAttributes().ofType(typeLoader.load(Object.class));
        MetadataType baseSchedulingStrategy = typeLoader.load(Scheduler.class);
        scheduler.onDefaultParameterGroup().withRequiredParameter("schedulingStrategy").ofType(baseSchedulingStrategy).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)scheduler.onDefaultParameterGroup().withOptionalParameter("disallowConcurrentExecution").ofType(typeLoader.load(Boolean.class))).defaultingTo((Object)false).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        MetadataType fixedFrequencyScheduler = typeLoader.load(FixedFrequencyScheduler.class);
        MetadataType cronScheduler = typeLoader.load(CronScheduler.class);
        extensionDeclarer.withSubType(baseSchedulingStrategy, fixedFrequencyScheduler);
        extensionDeclarer.withSubType(baseSchedulingStrategy, cronScheduler);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)baseSchedulingStrategy);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)fixedFrequencyScheduler);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)cronScheduler);
    }

    private void declareIdempotentValidator(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer validator = (OperationDeclarer)extensionDeclarer.withOperation("idempotentMessageValidator").describedAs("Ensures that only unique messages are received by a service by checking the unique ID of the incoming message. Note that the ID used can be generated from the message using an expression defined in the 'idExpression' attribute. Otherwise, a 'DUPLICATE_MESSAGE' error is generated.");
        validator.withOutput().ofType(typeLoader.load(Void.TYPE));
        validator.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("idExpression").ofType(typeLoader.load(String.class))).defaultingTo((Object)"#[correlationId]").withDsl(ParameterDslConfiguration.builder().allowsReferences(false).build())).describedAs("The expression to use when extracting the ID from the message. If this property is not set, '#[correlationId]' will be used by default.");
        ((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("valueExpression").ofType(typeLoader.load(String.class))).defaultingTo((Object)"#[correlationId]").describedAs("The expression to use when extracting the value from the message.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("storePrefix").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Defines the prefix of the object store names. This will only be used for the internally built object store.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("objectStore").withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(true).build())).ofType(typeLoader.load(ObjectStore.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.OBJECT_STORE))).describedAs("The object store where the IDs of the processed events are going to be stored. If defined as an argument, it should reference a globally created object store. Otherwise, it can be defined inline or not at all. In the last case, a default object store will be provided.");
        validator.withErrorModel(this.duplicateMessageError);
    }

    private void declareAsync(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer async = (ConstructDeclarer)extensionDeclarer.withConstruct("async").describedAs("Processes the nested list of message processors asynchronously.");
        async.withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)async.onDefaultParameterGroup().withOptionalParameter("name").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(typeLoader.load(String.class))).describedAs("Name that will be used to identify the async scheduling tasks.");
        ((OptionalParameterDeclarer)async.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").describedAs("The maximum concurrency. This value determines the maximum level of parallelism that this async router can use to optimize its performance when processing messages.")).ofType(typeLoader.load(Integer.class));
    }

    private void declareFlowRef(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer flowRef = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("flowRef").describedAs("Allows a 'flow' to be referenced so that message processing will continue in the referenced flow before returning. Message processing in the referenced 'flow' will occur within the context of the referenced flow and will therefore use its error handler etc.")).withErrorModel(this.routingError);
        flowRef.withOutput().ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build());
        flowRef.withOutputAttributes().ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build());
        flowRef.onDefaultParameterGroup().withRequiredParameter("name").ofType(typeLoader.load(String.class)).withAllowedStereotypes(Arrays.asList(MuleStereotypes.FLOW, MuleStereotypes.SUB_FLOW)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The name of the flow to call");
    }

    private void declareLogger(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer logger = (OperationDeclarer)extensionDeclarer.withOperation("logger").describedAs("Performs logging using an expression to determine the message to be logged. By default, if a message is not specified, the current Mule Message is logged using the INFO level to the 'org.mule.runtime.core.api.processor.LoggerMessageProcessor' category but the level and category can both be configured to suit your needs.");
        logger.withOutput().ofType(typeLoader.load(Void.TYPE));
        logger.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        ((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("message").ofType(typeLoader.load(String.class))).describedAs("The message that will be logged. Embedded expressions can be used to extract values from the current message. If no message is specified, then the current message is used.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("level").defaultingTo((Object)DEFAULT_LOG_LEVEL).ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().enumOf(new String[]{"ERROR", "WARN", DEFAULT_LOG_LEVEL, "DEBUG", "TRACE"}).build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets the log level. Default is INFO.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("category").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets the log category.");
    }

    private void declareSetPayload(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer setPayload = (OperationDeclarer)extensionDeclarer.withOperation("setPayload").describedAs("A processor that sets the payload with the provided value.");
        setPayload.withOutput().ofType(typeLoader.load(Void.TYPE));
        setPayload.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        setPayload.onDefaultParameterGroup().withRequiredParameter("value").ofType(typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.SUPPORTED).describedAs("The value to be set on the payload. Supports expressions.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setPayload.onDefaultParameterGroup().withOptionalParameter("encoding").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The encoding of the value assigned to the payload.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setPayload.onDefaultParameterGroup().withOptionalParameter("mimeType").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The mime type, e.g. text/plain or application/json");
    }

    private void declareSetVariable(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer setVariable = (OperationDeclarer)extensionDeclarer.withOperation("setVariable").describedAs("A processor that adds variables.");
        setVariable.withOutput().ofType(typeLoader.load(Void.TYPE));
        setVariable.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        if (Boolean.getBoolean("mule.revertSupportExpressionsInVariableNameInSetVariable")) {
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("variableName").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of the variable.");
        } else {
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("variableName").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("The name of the variable.");
        }
        setVariable.onDefaultParameterGroup().withRequiredParameter("value").ofType(typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.SUPPORTED).describedAs("The value assigned to the variable. Supports expressions.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("encoding").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The encoding of the value assigned to the variable.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("mimeType").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The mime type of the value assigned to the variable, e.g. text/plain or application/json");
    }

    private void declareParseTemplate(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer parseTemplate = (OperationDeclarer)extensionDeclarer.withOperation("parseTemplate").describedAs("Parses a template defined inline.");
        parseTemplate.withOutput().ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build());
        parseTemplate.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("content").ofType(typeLoader.load(String.class))).withRole(ParameterRole.PRIMARY_CONTENT)).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("Template to be processed.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("location").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The location of the template. The order in which the processor will attempt to load the file is: from the file system, from a URL, then from the classpath.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("outputEncoding").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The encoding to be assigned to the result generated when parsing the template.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("outputMimeType").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The mime type to be assigned to the result generated when parsing the template, e.g. text/plain or application/json");
    }

    private void declareRemoveVariable(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer removeVariable = (OperationDeclarer)extensionDeclarer.withOperation("removeVariable").describedAs("A processor that removes variables by name or a wildcard expression.");
        removeVariable.withOutput().ofType(typeLoader.load(Void.TYPE));
        removeVariable.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)removeVariable.onDefaultParameterGroup().withOptionalParameter("variableName").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The variable name.");
    }

    private void declareRaiseError(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer raiseError = (OperationDeclarer)extensionDeclarer.withOperation("raiseError").describedAs("Throws an error with the specified type and description.");
        raiseError.withOutput().ofType(typeLoader.load(Void.TYPE));
        raiseError.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        raiseError.onDefaultParameterGroup().withRequiredParameter("type").ofType(typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The error type to raise.");
        ((OptionalParameterDeclarer)raiseError.onDefaultParameterGroup().withOptionalParameter("description").ofType(typeLoader.load(String.class))).describedAs("The description of this error.");
    }

    private void declareForEach(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer forEach = (ConstructDeclarer)extensionDeclarer.withConstruct("foreach").describedAs("The foreach Processor allows iterating over a collection payload, or any collection obtained by an expression, generating a message for each element.");
        forEach.withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("collection").ofType(typeLoader.load(new TypeToken<Iterable<Object>>(){}.getType()))).defaultingTo((Object)"#[payload]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("Expression that defines the collection to iterate over.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("batchSize").ofType(typeLoader.load(Integer.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Partitions the collection in sub-collections of the specified size.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("rootMessageVariableName").ofType(typeLoader.load(String.class))).defaultingTo((Object)"rootMessage").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Variable name for the original message.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("counterVariableName").ofType(typeLoader.load(String.class))).defaultingTo((Object)"counter").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Variable name for the item number being processed.");
    }

    private void declareUntilSuccessful(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer untilSuccessful = (ConstructDeclarer)extensionDeclarer.withConstruct("untilSuccessful").describedAs("Attempts to route a message to its inner chain in a synchronous manner. Routing is considered successful if no error has been raised and, optionally, if the response matches an expression.");
        untilSuccessful.withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)untilSuccessful.onDefaultParameterGroup().withOptionalParameter("maxRetries").ofType(typeLoader.load(Integer.class))).defaultingTo((Object)5).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("Specifies the maximum number of processing retries that will be performed.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)untilSuccessful.onDefaultParameterGroup().withOptionalParameter("millisBetweenRetries").ofType(typeLoader.load(Integer.class))).defaultingTo((Object)60000).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("Specifies the minimum time interval between two process retries in milliseconds.\n The actual time interval depends on the previous execution but should not exceed twice this number.\n Default value is 60000 (one minute)");
    }

    private void declareChoice(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer choice = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("choice").describedAs("Sends the message to the first message processor whose condition is satisfied. If none of the conditions are satisfied, it sends the message to the configured default message processor or fails if there is none.")).withErrorModel(this.routingError);
        NestedRouteDeclarer when = choice.withRoute("when").withMinOccurs(1);
        when.withChain();
        when.onDefaultParameterGroup().withRequiredParameter("expression").ofType(typeLoader.load(Boolean.TYPE)).describedAs("The expression to evaluate.");
        choice.withRoute("otherwise").withMaxOccurs(Integer.valueOf(1)).withChain();
    }

    private void declareFlow(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer flow = (ConstructDeclarer)extensionDeclarer.withConstruct("flow").allowingTopLevelDefinition().withStereotype(MuleStereotypes.FLOW);
        flow.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(typeLoader.load(String.class));
        flow.onDefaultParameterGroup().withOptionalParameter("initialState").defaultingTo((Object)"started").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().enumOf(new String[]{"started", "stopped"}).build());
        ((OptionalParameterDeclarer)flow.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").describedAs("The maximum concurrency. This value determines the maximum level of parallelism that the Flow can use to optimize its performance when processing messages.")).ofType(typeLoader.load(Integer.class));
        flow.withComponent("source").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.SOURCE});
        flow.withChain().setRequired(true);
        flow.withComponent("errorHandler").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.ERROR_HANDLER});
    }

    private void declareSubflow(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer subFlow = (ConstructDeclarer)extensionDeclarer.withConstruct("subFlow").allowingTopLevelDefinition().withStereotype(MuleStereotypes.SUB_FLOW);
        subFlow.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(typeLoader.load(String.class));
        subFlow.withChain().setRequired(true).withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.PROCESSOR});
    }

    private void declareFirstSuccessful(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer firstSuccessful = (ConstructDeclarer)extensionDeclarer.withConstruct("firstSuccessful").describedAs("Sends a message to a list of message processors until one processes it successfully.");
        firstSuccessful.withRoute("route").withChain();
    }

    private void declareRoundRobin(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer roundRobin = (ConstructDeclarer)extensionDeclarer.withConstruct("roundRobin").describedAs("Send each message received to the next message processor in a circular list of targets.");
        roundRobin.withRoute("route").withChain();
    }

    private void declareScatterGather(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer scatterGather = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("scatterGather").describedAs("Sends the same message to multiple message processors in parallel.")).withErrorModel(this.compositeRoutingError);
        scatterGather.withRoute("route").withMinOccurs(2).withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onDefaultParameterGroup().withOptionalParameter("timeout").ofType(typeLoader.load(Long.class))).defaultingTo((Object)Long.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets a timeout in milliseconds for each route. Values lower or equals than zero means no timeout.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").ofType(typeLoader.load(Integer.class))).defaultingTo((Object)Integer.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("This value determines the maximum level of parallelism that will be used by this router.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onDefaultParameterGroup().withOptionalParameter("target").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of a variable on which the operation's output will be placed")).withLayout(LayoutModel.builder().tabName("Advanced").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onDefaultParameterGroup().withOptionalParameter("targetValue").ofType(typeLoader.load(String.class))).defaultingTo((Object)"#[payload]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable")).withRole(ParameterRole.BEHAVIOUR)).withDisplayModel(DisplayModel.builder().displayName("Target Value").build())).withLayout(LayoutModel.builder().tabName("Advanced").build())).withModelProperty((ModelProperty)new TargetModelProperty());
    }

    private void declareParallelForEach(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer parallelForeach = (ConstructDeclarer)((ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("parallelForeach").describedAs("Splits the same message and processes each part in parallel.")).withErrorModel(this.compositeRoutingError)).withModelProperty((ModelProperty)new SinceMuleVersionModelProperty("4.2.0"));
        parallelForeach.withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("collection").ofType(typeLoader.load(new TypeToken<Iterable<Object>>(){}.getType()))).withRole(ParameterRole.BEHAVIOUR)).withExpressionSupport(ExpressionSupport.REQUIRED)).defaultingTo((Object)"#[payload]").describedAs("Expression that defines the collection of parts to be processed in parallel.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("timeout").ofType(typeLoader.load(Long.class))).defaultingTo((Object)Long.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets a timeout in milliseconds for each route. Values lower or equals than zero means no timeout.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").ofType(typeLoader.load(Integer.class))).defaultingTo((Object)Integer.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("This value determines the maximum level of parallelism that will be used by this router.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("target").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of a variable on which the operation's output will be placed")).withLayout(LayoutModel.builder().tabName("Advanced").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("targetValue").ofType(typeLoader.load(String.class))).defaultingTo((Object)"#[payload]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable")).withRole(ParameterRole.BEHAVIOUR)).withDisplayModel(DisplayModel.builder().displayName("Target Value").build())).withLayout(LayoutModel.builder().tabName("Advanced").build())).withModelProperty((ModelProperty)new TargetModelProperty());
    }

    private void declareTry(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer tryScope = (ConstructDeclarer)extensionDeclarer.withConstruct("try").describedAs("Processes the nested list of message processors, within a transaction and with it's own error handler if required.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)tryScope.onDefaultParameterGroup().withOptionalParameter("transactionalAction").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().enumOf(new String[]{"INDIFFERENT", "ALWAYS_BEGIN", "BEGIN_OR_JOIN"}).build())).defaultingTo((Object)"INDIFFERENT").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().tabName("Transactions").build())).describedAs("The action to take regarding transactions. By default nothing will be done.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)tryScope.onDefaultParameterGroup().withOptionalParameter("transactionType").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().enumOf(new String[]{"LOCAL", "XA"}).build())).defaultingTo((Object)"LOCAL").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Transaction type supported. Availability will depend on the runtime version, though LOCAL is always available.");
        tryScope.withChain();
        tryScope.withOptionalComponent("errorHandler").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.ERROR_HANDLER});
    }

    private void declareErrorHandler(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer errorHandler = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("errorHandler").withStereotype(MuleStereotypes.ERROR_HANDLER)).allowingTopLevelDefinition().describedAs("Allows the definition of internal selective handlers. It will route the error to the first handler that matches it. If there's no match, then a default error handler will be executed.");
        errorHandler.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(typeLoader.load(String.class));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)errorHandler.onDefaultParameterGroup().withOptionalParameter("ref").withAllowedStereotypes(Collections.singletonList(MuleStereotypes.ERROR_HANDLER))).ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of the error handler to reuse.");
        NestedRouteDeclarer onErrorContinue = errorHandler.withRoute("onErrorContinue").describedAs("Error handler used to handle errors. It will commit any transaction as if the message was consumed successfully.");
        this.declareOnErrorRoute(typeLoader, onErrorContinue);
        NestedRouteDeclarer onErrorPropagate = errorHandler.withRoute("onErrorPropagate").describedAs("Error handler used to propagate errors. It will rollback any transaction and not consume messages.");
        this.declareOnErrorRoute(typeLoader, onErrorPropagate);
        errorHandler.withOptionalComponent("onError").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.ON_ERROR}).describedAs("Error handler used to reference others.");
        ConstructDeclarer onError = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("onError").withStereotype(MuleStereotypes.ON_ERROR)).describedAs("Error handler used to reference others.");
        onError.onDefaultParameterGroup().withRequiredParameter("ref").withAllowedStereotypes(Arrays.asList(MuleStereotypes.ON_ERROR)).ofType(typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The name of the error handler to reuse.");
        this.declareGlobalOnErrorRoute(typeLoader, (ConstructDeclarer)extensionDeclarer.withConstruct("onErrorContinue").describedAs("Error handler used to handle errors. It will commit any transaction as if the message was consumed successfully."));
        this.declareGlobalOnErrorRoute(typeLoader, (ConstructDeclarer)extensionDeclarer.withConstruct("onErrorPropagate").describedAs("Error handler used to propagate errors. It will rollback any transaction and not consume messages."));
    }

    private void declareOnErrorRoute(ClassTypeLoader typeLoader, NestedRouteDeclarer onError) {
        onError.withChain();
        ((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("when").ofType(typeLoader.load(String.class))).describedAs("The expression that will be evaluated to determine if this exception strategy should be executed. This should always be a boolean expression.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("type").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().enumOf(new String[]{"ANY", "REDELIVERY_EXHAUSTED", "TRANSFORMATION", "EXPRESSION", "SECURITY", "CLIENT_SECURITY", "SERVER_SECURITY", "ROUTING", "CONNECTIVITY", "RETRY_EXHAUSTED", "TIMEOUT"}).build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The full name of the error type to match against or a comma separated list of full names, to match against any of them.");
        ((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("logException").ofType(typeLoader.load(Boolean.TYPE))).defaultingTo((Object)true).describedAs("Determines whether the handled exception will be logged to its standard logger in the ERROR level before being handled. Default is true.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("enableNotifications").ofType(typeLoader.load(Boolean.TYPE))).defaultingTo((Object)true).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Determines whether ExceptionNotifications will be fired from this strategy when an exception occurs. Default is true.");
    }

    private void declareGlobalOnErrorRoute(ClassTypeLoader typeLoader, ConstructDeclarer onError) {
        ((ConstructDeclarer)onError.withStereotype(MuleStereotypes.ON_ERROR)).allowingTopLevelDefinition().withChain();
        onError.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(typeLoader.load(String.class));
    }

    private void declareErrors(ExtensionDeclarer extensionDeclarer) {
        ErrorModel criticalError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.CRITICAL).handleable(false).build();
        ErrorModel overloadError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).withParent(criticalError).build();
        ErrorModel securityError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SECURITY).withParent(this.anyError).build();
        ErrorModel sourceError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE).withParent(this.anyError).build();
        ErrorModel sourceResponseError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE).withParent(this.anyError).build();
        ErrorModel serverSecurityError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY).withParent(securityError).build();
        extensionDeclarer.withErrorModel(this.anyError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.EXPRESSION).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.TRANSFORMATION).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.CONNECTIVITY).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.RETRY_EXHAUSTED).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.STREAM_MAXIMUM_SIZE_EXCEEDED).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.TIMEOUT).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.UNKNOWN).handleable(false).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(this.routingError);
        extensionDeclarer.withErrorModel(this.compositeRoutingError);
        extensionDeclarer.withErrorModel(this.validationError);
        extensionDeclarer.withErrorModel(this.duplicateMessageError);
        extensionDeclarer.withErrorModel(securityError);
        extensionDeclarer.withErrorModel(serverSecurityError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.CLIENT_SECURITY).withParent(securityError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.NOT_PERMITTED).withParent(securityError).build());
        extensionDeclarer.withErrorModel(sourceError);
        extensionDeclarer.withErrorModel(sourceResponseError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE).handleable(false).withParent(sourceError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND).handleable(false).withParent(sourceError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE).withParent(sourceResponseError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND).handleable(false).withParent(sourceResponseError).build());
        extensionDeclarer.withErrorModel(criticalError);
        extensionDeclarer.withErrorModel(overloadError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).handleable(false).withParent(overloadError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.FATAL).handleable(false).withParent(criticalError).build());
    }

    private void declareConfiguration(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer configuration = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("configuration").allowingTopLevelDefinition().withStereotype(MuleStereotypes.APP_CONFIG)).describedAs("Specifies defaults and general settings for the Mule instance.");
        InfrastructureParameterBuilder.addReconnectionStrategyParameter((ParameterizedDeclaration)((ParameterizedDeclaration)configuration.getDeclaration()));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultResponseTimeout").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"10000").describedAs("The default period (ms) to wait for a synchronous response.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultTransactionTimeout").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"30000").describedAs("The default timeout (ms) for transactions. This can also be configured on transactions, in which case the transaction configuration is used instead of this default.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultErrorHandler-ref").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.ERROR_HANDLER))).describedAs("The default error handler for every flow. This must be a reference to a global error handler.")).withDsl(ParameterDslConfiguration.builder().allowsReferences(true).allowsInlineDefinition(false).allowTopLevelDefinition(false).build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("inheritIterableRepeatability").ofType(typeLoader.load(Boolean.TYPE))).defaultingTo((Object)false).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Whether streamed iterable objects should follow the repeatability strategy of the iterable or use the default one.")).withModelProperty((ModelProperty)new SinceMuleVersionModelProperty("4.3.0"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("shutdownTimeout").ofType(typeLoader.load(Integer.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"5000").describedAs("The time in milliseconds to wait for any in-progress work to finish running before Mule shuts down. After this threshold has been reached, Mule starts stopping schedulers and interrupting threads, and messages can be lost. If you have a very large number of services in the same Mule instance, if you have components that take more than a couple seconds to process, or if you are using large payloads and/or slower transports, you should increase this value to allow more time for graceful shutdown. The value you specify is applied to services and separately to dispatchers, so the default value of 5000 milliseconds specifies that Mule has ten seconds to process and dispatch messages gracefully after shutdown is initiated.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("maxQueueTransactionFilesSize").ofType(typeLoader.load(Integer.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"500").describedAs("Sets the approximate maximum space in megabytes allowed for the transaction log files for transactional persistent queues. Take into account that this number applies both to the set of transaction log files for XA and for local transactions. If both types of transactions are used then the approximate maximum space used, will be twice the configured value.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultObjectSerializer-ref").ofType(typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.SERIALIZER))).describedAs("An optional reference to an ObjectSerializer to be used as the application's default")).withDsl(ParameterDslConfiguration.builder().allowsReferences(true).allowsInlineDefinition(false).allowTopLevelDefinition(false).build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("dynamicConfigExpiration").describedAs("Configuration about how should the runtime handle the expiration of dynamic configurations")).ofType(new DynamicConfigExpirationTypeBuilder().buildDynamicConfigExpirationType())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDsl(ParameterDslConfiguration.builder().allowsReferences(false).allowsInlineDefinition(true).allowTopLevelDefinition(false).build());
    }

    private void declareConfigurationProperties(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer configuration = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("configurationProperties").allowingTopLevelDefinition().withStereotype(MuleStereotypes.APP_CONFIG)).describedAs("Configuration properties are key/value pairs that can be stored in configuration files or set as system environment variables. \nEach property%2Cs value can be referenced inside the attributes of a mule configuration file by wrapping the property%2Cs key name in the syntax: \n${key_name}. \n At runtime, each property placeholder expression is substituted with the property's value. \nThis allows you to externalize configuration of properties outside the Mule application's deployable archive, and to allow others to change these properties based on the environment the application is being deployed to. Note that a system environment variable with a matching key name will override the same key%2Cs value from a properties file. Each property has a key and a value. \nThe key can be referenced from the mule configuration files using the following semantics: \n${key_name}. This allows to externalize configuration and change it based\non the environment the application is being deployed to.");
        configuration.onDefaultParameterGroup().withRequiredParameter("file").ofType(typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDisplayModel(DisplayModel.builder().path(new PathModel(PathModel.Type.FILE, false, PathModel.Location.EMBEDDED, new String[]{"yaml", "properties"})).build()).describedAs(" The location of the file with the configuration properties to use. It may be a location in the classpath or an absolute location. \nThe file location value may also contains references to properties that will only be resolved based on system properties or properties set at deployment time.");
    }
}

