/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.util;

import java.util.Base64;
import org.mule.weave.v2.exception.InvalidBase64ContentException;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class BinaryHelper$ {
    public static BinaryHelper$ MODULE$;
    private final char[] hexCode;

    static {
        new BinaryHelper$();
    }

    public byte[] fromBase64String(String base64String, LocationCapable locationCapable) {
        byte[] byArray;
        try {
            byArray = Base64.getDecoder().decode(base64String.replaceAll("\\s", ""));
        }
        catch (IllegalArgumentException ia) {
            throw new InvalidBase64ContentException(locationCapable.location(), ia.getMessage());
        }
        return byArray;
    }

    public String toBase64String(SeekableStream binaryContent) {
        byte[] bytes = BinaryValue$.MODULE$.getBytesFromSeekableStream(binaryContent, BinaryValue$.MODULE$.getBytesFromSeekableStream$default$2());
        return Base64.getEncoder().encodeToString(bytes);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] fromHexString(String hexString) {
        void var3_3;
        int len = hexString.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(35).append("hexBinary needs to be even-length: ").append(hexString).toString());
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = this.hexToBin(hexString.charAt(i));
            int l = this.hexToBin(hexString.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(42).append("contains illegal character for hexBinary: ").append(hexString).toString());
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return var3_3;
    }

    private int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    private char[] hexCode() {
        return this.hexCode;
    }

    public String toHexString(byte[] binaryContent) {
        StringBuilder r = new StringBuilder(binaryContent.length * 2);
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(binaryContent)).foreach((Function1 & java.io.Serializable & Serializable)b -> BinaryHelper$.$anonfun$toHexString$1(r, BoxesRunTime.unboxToByte((Object)b)));
        return r.toString();
    }

    public static final /* synthetic */ StringBuilder $anonfun$toHexString$1(StringBuilder r$1, byte b) {
        r$1.append(MODULE$.hexCode()[b >> 4 & 0xF]);
        return r$1.append(MODULE$.hexCode()[b & 0xF]);
    }

    private BinaryHelper$() {
        MODULE$ = this;
        this.hexCode = "0123456789ABCDEF".toCharArray();
    }
}

