/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.resolution.VersionRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionResult {
    private final VersionRequest request;
    private List<Exception> exceptions;
    private String version;
    private ArtifactRepository repository;

    public VersionResult(VersionRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("version request has not been specified");
        }
        this.request = request;
        this.exceptions = Collections.emptyList();
    }

    public VersionRequest getRequest() {
        return this.request;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public VersionResult addException(Exception exception) {
        if (exception != null) {
            if (this.exceptions.isEmpty()) {
                this.exceptions = new ArrayList<Exception>();
            }
            this.exceptions.add(exception);
        }
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public VersionResult setVersion(String version) {
        this.version = version;
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public VersionResult setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public String toString() {
        return this.getVersion() + " @ " + this.getRepository();
    }
}

